/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceIDPropertiesKHX
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEUUID;
    public static final int DRIVERUUID;
    public static final int DEVICELUID;
    public static final int DEVICELUIDVALID;

    VkPhysicalDeviceIDPropertiesKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceIDPropertiesKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceIDPropertiesKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPhysicalDeviceIDPropertiesKHX.nsType(this.address());
    }

    public long pNext() {
        return VkPhysicalDeviceIDPropertiesKHX.npNext(this.address());
    }

    public ByteBuffer deviceUUID() {
        return VkPhysicalDeviceIDPropertiesKHX.ndeviceUUID(this.address());
    }

    public byte deviceUUID(int index) {
        return VkPhysicalDeviceIDPropertiesKHX.ndeviceUUID(this.address(), index);
    }

    public ByteBuffer driverUUID() {
        return VkPhysicalDeviceIDPropertiesKHX.ndriverUUID(this.address());
    }

    public byte driverUUID(int index) {
        return VkPhysicalDeviceIDPropertiesKHX.ndriverUUID(this.address(), index);
    }

    public ByteBuffer deviceLUID() {
        return VkPhysicalDeviceIDPropertiesKHX.ndeviceLUID(this.address());
    }

    public byte deviceLUID(int index) {
        return VkPhysicalDeviceIDPropertiesKHX.ndeviceLUID(this.address(), index);
    }

    public boolean deviceLUIDValid() {
        return VkPhysicalDeviceIDPropertiesKHX.ndeviceLUIDValid(this.address()) != 0;
    }

    public static VkPhysicalDeviceIDPropertiesKHX create(long address) {
        return address == 0L ? null : new VkPhysicalDeviceIDPropertiesKHX(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static ByteBuffer ndeviceUUID(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DEVICEUUID, 16);
    }

    public static byte ndeviceUUID(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        return MemoryUtil.memGetByte(struct + (long)DEVICEUUID + (long)(index * 1));
    }

    public static ByteBuffer ndriverUUID(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DRIVERUUID, 16);
    }

    public static byte ndriverUUID(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        return MemoryUtil.memGetByte(struct + (long)DRIVERUUID + (long)(index * 1));
    }

    public static ByteBuffer ndeviceLUID(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DEVICELUID, 8);
    }

    public static byte ndeviceLUID(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        return MemoryUtil.memGetByte(struct + (long)DEVICELUID + (long)(index * 1));
    }

    public static int ndeviceLUIDValid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICELUIDVALID);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceIDPropertiesKHX.__struct(VkPhysicalDeviceIDPropertiesKHX.__member(4), VkPhysicalDeviceIDPropertiesKHX.__member(POINTER_SIZE), VkPhysicalDeviceIDPropertiesKHX.__array(1, 16), VkPhysicalDeviceIDPropertiesKHX.__array(1, 16), VkPhysicalDeviceIDPropertiesKHX.__array(1, 8), VkPhysicalDeviceIDPropertiesKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEUUID = layout.offsetof(2);
        DRIVERUUID = layout.offsetof(3);
        DEVICELUID = layout.offsetof(4);
        DEVICELUIDVALID = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceIDPropertiesKHX, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceIDPropertiesKHX newInstance(long address) {
            return new VkPhysicalDeviceIDPropertiesKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPhysicalDeviceIDPropertiesKHX.nsType(this.address());
        }

        public long pNext() {
            return VkPhysicalDeviceIDPropertiesKHX.npNext(this.address());
        }

        public ByteBuffer deviceUUID() {
            return VkPhysicalDeviceIDPropertiesKHX.ndeviceUUID(this.address());
        }

        public byte deviceUUID(int index) {
            return VkPhysicalDeviceIDPropertiesKHX.ndeviceUUID(this.address(), index);
        }

        public ByteBuffer driverUUID() {
            return VkPhysicalDeviceIDPropertiesKHX.ndriverUUID(this.address());
        }

        public byte driverUUID(int index) {
            return VkPhysicalDeviceIDPropertiesKHX.ndriverUUID(this.address(), index);
        }

        public ByteBuffer deviceLUID() {
            return VkPhysicalDeviceIDPropertiesKHX.ndeviceLUID(this.address());
        }

        public byte deviceLUID(int index) {
            return VkPhysicalDeviceIDPropertiesKHX.ndeviceLUID(this.address(), index);
        }

        public boolean deviceLUIDValid() {
            return VkPhysicalDeviceIDPropertiesKHX.ndeviceLUIDValid(this.address()) != 0;
        }
    }
}

