/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkMemoryHeap;
import org.lwjgl.vulkan.VkMemoryType;

public class VkPhysicalDeviceMemoryProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORYTYPECOUNT;
    public static final int MEMORYTYPES;
    public static final int MEMORYHEAPCOUNT;
    public static final int MEMORYHEAPS;

    VkPhysicalDeviceMemoryProperties(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceMemoryProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceMemoryProperties.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int memoryTypeCount() {
        return VkPhysicalDeviceMemoryProperties.nmemoryTypeCount(this.address());
    }

    public VkMemoryType.Buffer memoryTypes() {
        return VkPhysicalDeviceMemoryProperties.nmemoryTypes(this.address());
    }

    public VkMemoryType memoryTypes(int index) {
        return VkPhysicalDeviceMemoryProperties.nmemoryTypes(this.address(), index);
    }

    public int memoryHeapCount() {
        return VkPhysicalDeviceMemoryProperties.nmemoryHeapCount(this.address());
    }

    public VkMemoryHeap.Buffer memoryHeaps() {
        return VkPhysicalDeviceMemoryProperties.nmemoryHeaps(this.address());
    }

    public VkMemoryHeap memoryHeaps(int index) {
        return VkPhysicalDeviceMemoryProperties.nmemoryHeaps(this.address(), index);
    }

    public static VkPhysicalDeviceMemoryProperties malloc() {
        return VkPhysicalDeviceMemoryProperties.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPhysicalDeviceMemoryProperties calloc() {
        return VkPhysicalDeviceMemoryProperties.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPhysicalDeviceMemoryProperties create() {
        return new VkPhysicalDeviceMemoryProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPhysicalDeviceMemoryProperties create(long address) {
        return address == 0L ? null : new VkPhysicalDeviceMemoryProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceMemoryProperties.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceMemoryProperties.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPhysicalDeviceMemoryProperties mallocStack() {
        return VkPhysicalDeviceMemoryProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceMemoryProperties callocStack() {
        return VkPhysicalDeviceMemoryProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceMemoryProperties mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceMemoryProperties callocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceMemoryProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceMemoryProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmemoryTypeCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYTYPECOUNT);
    }

    public static VkMemoryType.Buffer nmemoryTypes(long struct) {
        return VkMemoryType.create(struct + (long)MEMORYTYPES, VkPhysicalDeviceMemoryProperties.nmemoryTypeCount(struct));
    }

    public static VkMemoryType nmemoryTypes(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 32);
        }
        return VkMemoryType.create(struct + (long)MEMORYTYPES + (long)(index * VkMemoryType.SIZEOF));
    }

    public static int nmemoryHeapCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYHEAPCOUNT);
    }

    public static VkMemoryHeap.Buffer nmemoryHeaps(long struct) {
        return VkMemoryHeap.create(struct + (long)MEMORYHEAPS, VkPhysicalDeviceMemoryProperties.nmemoryHeapCount(struct));
    }

    public static VkMemoryHeap nmemoryHeaps(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        return VkMemoryHeap.create(struct + (long)MEMORYHEAPS + (long)(index * VkMemoryHeap.SIZEOF));
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceMemoryProperties.__struct(VkPhysicalDeviceMemoryProperties.__member(4), VkPhysicalDeviceMemoryProperties.__array(VkMemoryType.SIZEOF, VkMemoryType.ALIGNOF, 32), VkPhysicalDeviceMemoryProperties.__member(4), VkPhysicalDeviceMemoryProperties.__array(VkMemoryHeap.SIZEOF, VkMemoryHeap.ALIGNOF, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORYTYPECOUNT = layout.offsetof(0);
        MEMORYTYPES = layout.offsetof(1);
        MEMORYHEAPCOUNT = layout.offsetof(2);
        MEMORYHEAPS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceMemoryProperties, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceMemoryProperties newInstance(long address) {
            return new VkPhysicalDeviceMemoryProperties(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int memoryTypeCount() {
            return VkPhysicalDeviceMemoryProperties.nmemoryTypeCount(this.address());
        }

        public VkMemoryType.Buffer memoryTypes() {
            return VkPhysicalDeviceMemoryProperties.nmemoryTypes(this.address());
        }

        public VkMemoryType memoryTypes(int index) {
            return VkPhysicalDeviceMemoryProperties.nmemoryTypes(this.address(), index);
        }

        public int memoryHeapCount() {
            return VkPhysicalDeviceMemoryProperties.nmemoryHeapCount(this.address());
        }

        public VkMemoryHeap.Buffer memoryHeaps() {
            return VkPhysicalDeviceMemoryProperties.nmemoryHeaps(this.address());
        }

        public VkMemoryHeap memoryHeaps(int index) {
            return VkPhysicalDeviceMemoryProperties.nmemoryHeaps(this.address(), index);
        }
    }
}

