/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkStencilOpState;

public class VkPipelineDepthStencilStateCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DEPTHTESTENABLE;
    public static final int DEPTHWRITEENABLE;
    public static final int DEPTHCOMPAREOP;
    public static final int DEPTHBOUNDSTESTENABLE;
    public static final int STENCILTESTENABLE;
    public static final int FRONT;
    public static final int BACK;
    public static final int MINDEPTHBOUNDS;
    public static final int MAXDEPTHBOUNDS;

    VkPipelineDepthStencilStateCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineDepthStencilStateCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineDepthStencilStateCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPipelineDepthStencilStateCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkPipelineDepthStencilStateCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkPipelineDepthStencilStateCreateInfo.nflags(this.address());
    }

    public boolean depthTestEnable() {
        return VkPipelineDepthStencilStateCreateInfo.ndepthTestEnable(this.address()) != 0;
    }

    public boolean depthWriteEnable() {
        return VkPipelineDepthStencilStateCreateInfo.ndepthWriteEnable(this.address()) != 0;
    }

    public int depthCompareOp() {
        return VkPipelineDepthStencilStateCreateInfo.ndepthCompareOp(this.address());
    }

    public boolean depthBoundsTestEnable() {
        return VkPipelineDepthStencilStateCreateInfo.ndepthBoundsTestEnable(this.address()) != 0;
    }

    public boolean stencilTestEnable() {
        return VkPipelineDepthStencilStateCreateInfo.nstencilTestEnable(this.address()) != 0;
    }

    public VkStencilOpState front() {
        return VkPipelineDepthStencilStateCreateInfo.nfront(this.address());
    }

    public VkStencilOpState back() {
        return VkPipelineDepthStencilStateCreateInfo.nback(this.address());
    }

    public float minDepthBounds() {
        return VkPipelineDepthStencilStateCreateInfo.nminDepthBounds(this.address());
    }

    public float maxDepthBounds() {
        return VkPipelineDepthStencilStateCreateInfo.nmaxDepthBounds(this.address());
    }

    public VkPipelineDepthStencilStateCreateInfo sType(int value) {
        VkPipelineDepthStencilStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo pNext(long value) {
        VkPipelineDepthStencilStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo flags(int value) {
        VkPipelineDepthStencilStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo depthTestEnable(boolean value) {
        VkPipelineDepthStencilStateCreateInfo.ndepthTestEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo depthWriteEnable(boolean value) {
        VkPipelineDepthStencilStateCreateInfo.ndepthWriteEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo depthCompareOp(int value) {
        VkPipelineDepthStencilStateCreateInfo.ndepthCompareOp(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo depthBoundsTestEnable(boolean value) {
        VkPipelineDepthStencilStateCreateInfo.ndepthBoundsTestEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo stencilTestEnable(boolean value) {
        VkPipelineDepthStencilStateCreateInfo.nstencilTestEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo front(VkStencilOpState value) {
        VkPipelineDepthStencilStateCreateInfo.nfront(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo back(VkStencilOpState value) {
        VkPipelineDepthStencilStateCreateInfo.nback(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo minDepthBounds(float value) {
        VkPipelineDepthStencilStateCreateInfo.nminDepthBounds(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo maxDepthBounds(float value) {
        VkPipelineDepthStencilStateCreateInfo.nmaxDepthBounds(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo set(int sType, long pNext, int flags, boolean depthTestEnable, boolean depthWriteEnable, int depthCompareOp, boolean depthBoundsTestEnable, boolean stencilTestEnable, VkStencilOpState front, VkStencilOpState back, float minDepthBounds, float maxDepthBounds) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.depthTestEnable(depthTestEnable);
        this.depthWriteEnable(depthWriteEnable);
        this.depthCompareOp(depthCompareOp);
        this.depthBoundsTestEnable(depthBoundsTestEnable);
        this.stencilTestEnable(stencilTestEnable);
        this.front(front);
        this.back(back);
        this.minDepthBounds(minDepthBounds);
        this.maxDepthBounds(maxDepthBounds);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo set(VkPipelineDepthStencilStateCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineDepthStencilStateCreateInfo malloc() {
        return VkPipelineDepthStencilStateCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPipelineDepthStencilStateCreateInfo calloc() {
        return VkPipelineDepthStencilStateCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPipelineDepthStencilStateCreateInfo create() {
        return new VkPipelineDepthStencilStateCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineDepthStencilStateCreateInfo create(long address) {
        return address == 0L ? null : new VkPipelineDepthStencilStateCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineDepthStencilStateCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineDepthStencilStateCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPipelineDepthStencilStateCreateInfo mallocStack() {
        return VkPipelineDepthStencilStateCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineDepthStencilStateCreateInfo callocStack() {
        return VkPipelineDepthStencilStateCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineDepthStencilStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineDepthStencilStateCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineDepthStencilStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineDepthStencilStateCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineDepthStencilStateCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineDepthStencilStateCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineDepthStencilStateCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineDepthStencilStateCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int ndepthTestEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTHTESTENABLE);
    }

    public static int ndepthWriteEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTHWRITEENABLE);
    }

    public static int ndepthCompareOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTHCOMPAREOP);
    }

    public static int ndepthBoundsTestEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTHBOUNDSTESTENABLE);
    }

    public static int nstencilTestEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STENCILTESTENABLE);
    }

    public static VkStencilOpState nfront(long struct) {
        return VkStencilOpState.create(struct + (long)FRONT);
    }

    public static VkStencilOpState nback(long struct) {
        return VkStencilOpState.create(struct + (long)BACK);
    }

    public static float nminDepthBounds(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MINDEPTHBOUNDS);
    }

    public static float nmaxDepthBounds(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAXDEPTHBOUNDS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ndepthTestEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTHTESTENABLE, value);
    }

    public static void ndepthWriteEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTHWRITEENABLE, value);
    }

    public static void ndepthCompareOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTHCOMPAREOP, value);
    }

    public static void ndepthBoundsTestEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTHBOUNDSTESTENABLE, value);
    }

    public static void nstencilTestEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STENCILTESTENABLE, value);
    }

    public static void nfront(long struct, VkStencilOpState value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FRONT, VkStencilOpState.SIZEOF);
    }

    public static void nback(long struct, VkStencilOpState value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BACK, VkStencilOpState.SIZEOF);
    }

    public static void nminDepthBounds(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MINDEPTHBOUNDS, value);
    }

    public static void nmaxDepthBounds(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MAXDEPTHBOUNDS, value);
    }

    static {
        Struct.Layout layout = VkPipelineDepthStencilStateCreateInfo.__struct(VkPipelineDepthStencilStateCreateInfo.__member(4), VkPipelineDepthStencilStateCreateInfo.__member(POINTER_SIZE), VkPipelineDepthStencilStateCreateInfo.__member(4), VkPipelineDepthStencilStateCreateInfo.__member(4), VkPipelineDepthStencilStateCreateInfo.__member(4), VkPipelineDepthStencilStateCreateInfo.__member(4), VkPipelineDepthStencilStateCreateInfo.__member(4), VkPipelineDepthStencilStateCreateInfo.__member(4), VkPipelineDepthStencilStateCreateInfo.__member(VkStencilOpState.SIZEOF, VkStencilOpState.ALIGNOF), VkPipelineDepthStencilStateCreateInfo.__member(VkStencilOpState.SIZEOF, VkStencilOpState.ALIGNOF), VkPipelineDepthStencilStateCreateInfo.__member(4), VkPipelineDepthStencilStateCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DEPTHTESTENABLE = layout.offsetof(3);
        DEPTHWRITEENABLE = layout.offsetof(4);
        DEPTHCOMPAREOP = layout.offsetof(5);
        DEPTHBOUNDSTESTENABLE = layout.offsetof(6);
        STENCILTESTENABLE = layout.offsetof(7);
        FRONT = layout.offsetof(8);
        BACK = layout.offsetof(9);
        MINDEPTHBOUNDS = layout.offsetof(10);
        MAXDEPTHBOUNDS = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineDepthStencilStateCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineDepthStencilStateCreateInfo newInstance(long address) {
            return new VkPipelineDepthStencilStateCreateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPipelineDepthStencilStateCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkPipelineDepthStencilStateCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkPipelineDepthStencilStateCreateInfo.nflags(this.address());
        }

        public boolean depthTestEnable() {
            return VkPipelineDepthStencilStateCreateInfo.ndepthTestEnable(this.address()) != 0;
        }

        public boolean depthWriteEnable() {
            return VkPipelineDepthStencilStateCreateInfo.ndepthWriteEnable(this.address()) != 0;
        }

        public int depthCompareOp() {
            return VkPipelineDepthStencilStateCreateInfo.ndepthCompareOp(this.address());
        }

        public boolean depthBoundsTestEnable() {
            return VkPipelineDepthStencilStateCreateInfo.ndepthBoundsTestEnable(this.address()) != 0;
        }

        public boolean stencilTestEnable() {
            return VkPipelineDepthStencilStateCreateInfo.nstencilTestEnable(this.address()) != 0;
        }

        public VkStencilOpState front() {
            return VkPipelineDepthStencilStateCreateInfo.nfront(this.address());
        }

        public VkStencilOpState back() {
            return VkPipelineDepthStencilStateCreateInfo.nback(this.address());
        }

        public float minDepthBounds() {
            return VkPipelineDepthStencilStateCreateInfo.nminDepthBounds(this.address());
        }

        public float maxDepthBounds() {
            return VkPipelineDepthStencilStateCreateInfo.nmaxDepthBounds(this.address());
        }

        public Buffer sType(int value) {
            VkPipelineDepthStencilStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkPipelineDepthStencilStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkPipelineDepthStencilStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer depthTestEnable(boolean value) {
            VkPipelineDepthStencilStateCreateInfo.ndepthTestEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer depthWriteEnable(boolean value) {
            VkPipelineDepthStencilStateCreateInfo.ndepthWriteEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer depthCompareOp(int value) {
            VkPipelineDepthStencilStateCreateInfo.ndepthCompareOp(this.address(), value);
            return this;
        }

        public Buffer depthBoundsTestEnable(boolean value) {
            VkPipelineDepthStencilStateCreateInfo.ndepthBoundsTestEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer stencilTestEnable(boolean value) {
            VkPipelineDepthStencilStateCreateInfo.nstencilTestEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer front(VkStencilOpState value) {
            VkPipelineDepthStencilStateCreateInfo.nfront(this.address(), value);
            return this;
        }

        public Buffer back(VkStencilOpState value) {
            VkPipelineDepthStencilStateCreateInfo.nback(this.address(), value);
            return this;
        }

        public Buffer minDepthBounds(float value) {
            VkPipelineDepthStencilStateCreateInfo.nminDepthBounds(this.address(), value);
            return this;
        }

        public Buffer maxDepthBounds(float value) {
            VkPipelineDepthStencilStateCreateInfo.nmaxDepthBounds(this.address(), value);
            return this;
        }
    }
}

