/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineInputAssemblyStateCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int TOPOLOGY;
    public static final int PRIMITIVERESTARTENABLE;

    VkPipelineInputAssemblyStateCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineInputAssemblyStateCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineInputAssemblyStateCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPipelineInputAssemblyStateCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkPipelineInputAssemblyStateCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkPipelineInputAssemblyStateCreateInfo.nflags(this.address());
    }

    public int topology() {
        return VkPipelineInputAssemblyStateCreateInfo.ntopology(this.address());
    }

    public boolean primitiveRestartEnable() {
        return VkPipelineInputAssemblyStateCreateInfo.nprimitiveRestartEnable(this.address()) != 0;
    }

    public VkPipelineInputAssemblyStateCreateInfo sType(int value) {
        VkPipelineInputAssemblyStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineInputAssemblyStateCreateInfo pNext(long value) {
        VkPipelineInputAssemblyStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineInputAssemblyStateCreateInfo flags(int value) {
        VkPipelineInputAssemblyStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineInputAssemblyStateCreateInfo topology(int value) {
        VkPipelineInputAssemblyStateCreateInfo.ntopology(this.address(), value);
        return this;
    }

    public VkPipelineInputAssemblyStateCreateInfo primitiveRestartEnable(boolean value) {
        VkPipelineInputAssemblyStateCreateInfo.nprimitiveRestartEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineInputAssemblyStateCreateInfo set(int sType, long pNext, int flags, int topology, boolean primitiveRestartEnable) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.topology(topology);
        this.primitiveRestartEnable(primitiveRestartEnable);
        return this;
    }

    public VkPipelineInputAssemblyStateCreateInfo set(VkPipelineInputAssemblyStateCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineInputAssemblyStateCreateInfo malloc() {
        return VkPipelineInputAssemblyStateCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPipelineInputAssemblyStateCreateInfo calloc() {
        return VkPipelineInputAssemblyStateCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPipelineInputAssemblyStateCreateInfo create() {
        return new VkPipelineInputAssemblyStateCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineInputAssemblyStateCreateInfo create(long address) {
        return address == 0L ? null : new VkPipelineInputAssemblyStateCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineInputAssemblyStateCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineInputAssemblyStateCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPipelineInputAssemblyStateCreateInfo mallocStack() {
        return VkPipelineInputAssemblyStateCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineInputAssemblyStateCreateInfo callocStack() {
        return VkPipelineInputAssemblyStateCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineInputAssemblyStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineInputAssemblyStateCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineInputAssemblyStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineInputAssemblyStateCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineInputAssemblyStateCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineInputAssemblyStateCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineInputAssemblyStateCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineInputAssemblyStateCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int ntopology(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TOPOLOGY);
    }

    public static int nprimitiveRestartEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRIMITIVERESTARTENABLE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ntopology(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TOPOLOGY, value);
    }

    public static void nprimitiveRestartEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PRIMITIVERESTARTENABLE, value);
    }

    static {
        Struct.Layout layout = VkPipelineInputAssemblyStateCreateInfo.__struct(VkPipelineInputAssemblyStateCreateInfo.__member(4), VkPipelineInputAssemblyStateCreateInfo.__member(POINTER_SIZE), VkPipelineInputAssemblyStateCreateInfo.__member(4), VkPipelineInputAssemblyStateCreateInfo.__member(4), VkPipelineInputAssemblyStateCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        TOPOLOGY = layout.offsetof(3);
        PRIMITIVERESTARTENABLE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineInputAssemblyStateCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineInputAssemblyStateCreateInfo newInstance(long address) {
            return new VkPipelineInputAssemblyStateCreateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPipelineInputAssemblyStateCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkPipelineInputAssemblyStateCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkPipelineInputAssemblyStateCreateInfo.nflags(this.address());
        }

        public int topology() {
            return VkPipelineInputAssemblyStateCreateInfo.ntopology(this.address());
        }

        public boolean primitiveRestartEnable() {
            return VkPipelineInputAssemblyStateCreateInfo.nprimitiveRestartEnable(this.address()) != 0;
        }

        public Buffer sType(int value) {
            VkPipelineInputAssemblyStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkPipelineInputAssemblyStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkPipelineInputAssemblyStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer topology(int value) {
            VkPipelineInputAssemblyStateCreateInfo.ntopology(this.address(), value);
            return this;
        }

        public Buffer primitiveRestartEnable(boolean value) {
            VkPipelineInputAssemblyStateCreateInfo.nprimitiveRestartEnable(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

