/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineMultisampleStateCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int RASTERIZATIONSAMPLES;
    public static final int SAMPLESHADINGENABLE;
    public static final int MINSAMPLESHADING;
    public static final int PSAMPLEMASK;
    public static final int ALPHATOCOVERAGEENABLE;
    public static final int ALPHATOONEENABLE;

    VkPipelineMultisampleStateCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineMultisampleStateCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineMultisampleStateCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPipelineMultisampleStateCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkPipelineMultisampleStateCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkPipelineMultisampleStateCreateInfo.nflags(this.address());
    }

    public int rasterizationSamples() {
        return VkPipelineMultisampleStateCreateInfo.nrasterizationSamples(this.address());
    }

    public boolean sampleShadingEnable() {
        return VkPipelineMultisampleStateCreateInfo.nsampleShadingEnable(this.address()) != 0;
    }

    public float minSampleShading() {
        return VkPipelineMultisampleStateCreateInfo.nminSampleShading(this.address());
    }

    public IntBuffer pSampleMask(int capacity) {
        return VkPipelineMultisampleStateCreateInfo.npSampleMask(this.address(), capacity);
    }

    public boolean alphaToCoverageEnable() {
        return VkPipelineMultisampleStateCreateInfo.nalphaToCoverageEnable(this.address()) != 0;
    }

    public boolean alphaToOneEnable() {
        return VkPipelineMultisampleStateCreateInfo.nalphaToOneEnable(this.address()) != 0;
    }

    public VkPipelineMultisampleStateCreateInfo sType(int value) {
        VkPipelineMultisampleStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo pNext(long value) {
        VkPipelineMultisampleStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo flags(int value) {
        VkPipelineMultisampleStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo rasterizationSamples(int value) {
        VkPipelineMultisampleStateCreateInfo.nrasterizationSamples(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo sampleShadingEnable(boolean value) {
        VkPipelineMultisampleStateCreateInfo.nsampleShadingEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo minSampleShading(float value) {
        VkPipelineMultisampleStateCreateInfo.nminSampleShading(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo pSampleMask(IntBuffer value) {
        VkPipelineMultisampleStateCreateInfo.npSampleMask(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo alphaToCoverageEnable(boolean value) {
        VkPipelineMultisampleStateCreateInfo.nalphaToCoverageEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo alphaToOneEnable(boolean value) {
        VkPipelineMultisampleStateCreateInfo.nalphaToOneEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo set(int sType, long pNext, int flags, int rasterizationSamples, boolean sampleShadingEnable, float minSampleShading, IntBuffer pSampleMask, boolean alphaToCoverageEnable, boolean alphaToOneEnable) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.rasterizationSamples(rasterizationSamples);
        this.sampleShadingEnable(sampleShadingEnable);
        this.minSampleShading(minSampleShading);
        this.pSampleMask(pSampleMask);
        this.alphaToCoverageEnable(alphaToCoverageEnable);
        this.alphaToOneEnable(alphaToOneEnable);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo set(VkPipelineMultisampleStateCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineMultisampleStateCreateInfo malloc() {
        return VkPipelineMultisampleStateCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPipelineMultisampleStateCreateInfo calloc() {
        return VkPipelineMultisampleStateCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPipelineMultisampleStateCreateInfo create() {
        return new VkPipelineMultisampleStateCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineMultisampleStateCreateInfo create(long address) {
        return address == 0L ? null : new VkPipelineMultisampleStateCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineMultisampleStateCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineMultisampleStateCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPipelineMultisampleStateCreateInfo mallocStack() {
        return VkPipelineMultisampleStateCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineMultisampleStateCreateInfo callocStack() {
        return VkPipelineMultisampleStateCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineMultisampleStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineMultisampleStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineMultisampleStateCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineMultisampleStateCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nrasterizationSamples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RASTERIZATIONSAMPLES);
    }

    public static int nsampleShadingEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLESHADINGENABLE);
    }

    public static float nminSampleShading(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MINSAMPLESHADING);
    }

    public static IntBuffer npSampleMask(long struct, int capacity) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PSAMPLEMASK), capacity);
    }

    public static int nalphaToCoverageEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALPHATOCOVERAGEENABLE);
    }

    public static int nalphaToOneEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALPHATOONEENABLE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nrasterizationSamples(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RASTERIZATIONSAMPLES, value);
    }

    public static void nsampleShadingEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLESHADINGENABLE, value);
    }

    public static void nminSampleShading(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MINSAMPLESHADING, value);
    }

    public static void npSampleMask(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSAMPLEMASK, MemoryUtil.memAddressSafe(value));
    }

    public static void nalphaToCoverageEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ALPHATOCOVERAGEENABLE, value);
    }

    public static void nalphaToOneEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ALPHATOONEENABLE, value);
    }

    static {
        Struct.Layout layout = VkPipelineMultisampleStateCreateInfo.__struct(VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(POINTER_SIZE), VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(POINTER_SIZE), VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RASTERIZATIONSAMPLES = layout.offsetof(3);
        SAMPLESHADINGENABLE = layout.offsetof(4);
        MINSAMPLESHADING = layout.offsetof(5);
        PSAMPLEMASK = layout.offsetof(6);
        ALPHATOCOVERAGEENABLE = layout.offsetof(7);
        ALPHATOONEENABLE = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineMultisampleStateCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineMultisampleStateCreateInfo newInstance(long address) {
            return new VkPipelineMultisampleStateCreateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPipelineMultisampleStateCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkPipelineMultisampleStateCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkPipelineMultisampleStateCreateInfo.nflags(this.address());
        }

        public int rasterizationSamples() {
            return VkPipelineMultisampleStateCreateInfo.nrasterizationSamples(this.address());
        }

        public boolean sampleShadingEnable() {
            return VkPipelineMultisampleStateCreateInfo.nsampleShadingEnable(this.address()) != 0;
        }

        public float minSampleShading() {
            return VkPipelineMultisampleStateCreateInfo.nminSampleShading(this.address());
        }

        public IntBuffer pSampleMask(int capacity) {
            return VkPipelineMultisampleStateCreateInfo.npSampleMask(this.address(), capacity);
        }

        public boolean alphaToCoverageEnable() {
            return VkPipelineMultisampleStateCreateInfo.nalphaToCoverageEnable(this.address()) != 0;
        }

        public boolean alphaToOneEnable() {
            return VkPipelineMultisampleStateCreateInfo.nalphaToOneEnable(this.address()) != 0;
        }

        public Buffer sType(int value) {
            VkPipelineMultisampleStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkPipelineMultisampleStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkPipelineMultisampleStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer rasterizationSamples(int value) {
            VkPipelineMultisampleStateCreateInfo.nrasterizationSamples(this.address(), value);
            return this;
        }

        public Buffer sampleShadingEnable(boolean value) {
            VkPipelineMultisampleStateCreateInfo.nsampleShadingEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer minSampleShading(float value) {
            VkPipelineMultisampleStateCreateInfo.nminSampleShading(this.address(), value);
            return this;
        }

        public Buffer pSampleMask(IntBuffer value) {
            VkPipelineMultisampleStateCreateInfo.npSampleMask(this.address(), value);
            return this;
        }

        public Buffer alphaToCoverageEnable(boolean value) {
            VkPipelineMultisampleStateCreateInfo.nalphaToCoverageEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer alphaToOneEnable(boolean value) {
            VkPipelineMultisampleStateCreateInfo.nalphaToOneEnable(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

