/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSpecializationInfo;

public class VkPipelineShaderStageCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int STAGE;
    public static final int MODULE;
    public static final int PNAME;
    public static final int PSPECIALIZATIONINFO;

    VkPipelineShaderStageCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineShaderStageCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineShaderStageCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPipelineShaderStageCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkPipelineShaderStageCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkPipelineShaderStageCreateInfo.nflags(this.address());
    }

    public int stage() {
        return VkPipelineShaderStageCreateInfo.nstage(this.address());
    }

    public long module() {
        return VkPipelineShaderStageCreateInfo.nmodule(this.address());
    }

    public ByteBuffer pName() {
        return VkPipelineShaderStageCreateInfo.npName(this.address());
    }

    public String pNameString() {
        return VkPipelineShaderStageCreateInfo.npNameString(this.address());
    }

    public VkSpecializationInfo pSpecializationInfo() {
        return VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address());
    }

    public VkPipelineShaderStageCreateInfo sType(int value) {
        VkPipelineShaderStageCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo pNext(long value) {
        VkPipelineShaderStageCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo flags(int value) {
        VkPipelineShaderStageCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo stage(int value) {
        VkPipelineShaderStageCreateInfo.nstage(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo module(long value) {
        VkPipelineShaderStageCreateInfo.nmodule(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo pName(ByteBuffer value) {
        VkPipelineShaderStageCreateInfo.npName(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo pSpecializationInfo(VkSpecializationInfo value) {
        VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo set(int sType, long pNext, int flags, int stage, long module, ByteBuffer pName, VkSpecializationInfo pSpecializationInfo) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.stage(stage);
        this.module(module);
        this.pName(pName);
        this.pSpecializationInfo(pSpecializationInfo);
        return this;
    }

    public VkPipelineShaderStageCreateInfo set(VkPipelineShaderStageCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineShaderStageCreateInfo malloc() {
        return VkPipelineShaderStageCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPipelineShaderStageCreateInfo calloc() {
        return VkPipelineShaderStageCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPipelineShaderStageCreateInfo create() {
        return new VkPipelineShaderStageCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineShaderStageCreateInfo create(long address) {
        return address == 0L ? null : new VkPipelineShaderStageCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineShaderStageCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineShaderStageCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPipelineShaderStageCreateInfo mallocStack() {
        return VkPipelineShaderStageCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineShaderStageCreateInfo callocStack() {
        return VkPipelineShaderStageCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineShaderStageCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineShaderStageCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineShaderStageCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineShaderStageCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineShaderStageCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineShaderStageCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineShaderStageCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineShaderStageCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nstage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STAGE);
    }

    public static long nmodule(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MODULE);
    }

    public static ByteBuffer npName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PNAME));
    }

    public static String npNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)PNAME));
    }

    public static VkSpecializationInfo npSpecializationInfo(long struct) {
        return VkSpecializationInfo.create(MemoryUtil.memGetAddress(struct + (long)PSPECIALIZATIONINFO));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nstage(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STAGE, value);
    }

    public static void nmodule(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MODULE, value);
    }

    public static void npName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PNAME, MemoryUtil.memAddress(value));
    }

    public static void npSpecializationInfo(long struct, VkSpecializationInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PSPECIALIZATIONINFO, VkPipelineShaderStageCreateInfo.addressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PNAME));
        long pSpecializationInfo = MemoryUtil.memGetAddress(struct + (long)PSPECIALIZATIONINFO);
        if (pSpecializationInfo != 0L) {
            VkSpecializationInfo.validate(pSpecializationInfo);
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkPipelineShaderStageCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkPipelineShaderStageCreateInfo.__struct(VkPipelineShaderStageCreateInfo.__member(4), VkPipelineShaderStageCreateInfo.__member(POINTER_SIZE), VkPipelineShaderStageCreateInfo.__member(4), VkPipelineShaderStageCreateInfo.__member(4), VkPipelineShaderStageCreateInfo.__member(8), VkPipelineShaderStageCreateInfo.__member(POINTER_SIZE), VkPipelineShaderStageCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        STAGE = layout.offsetof(3);
        MODULE = layout.offsetof(4);
        PNAME = layout.offsetof(5);
        PSPECIALIZATIONINFO = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineShaderStageCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineShaderStageCreateInfo newInstance(long address) {
            return new VkPipelineShaderStageCreateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPipelineShaderStageCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkPipelineShaderStageCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkPipelineShaderStageCreateInfo.nflags(this.address());
        }

        public int stage() {
            return VkPipelineShaderStageCreateInfo.nstage(this.address());
        }

        public long module() {
            return VkPipelineShaderStageCreateInfo.nmodule(this.address());
        }

        public ByteBuffer pName() {
            return VkPipelineShaderStageCreateInfo.npName(this.address());
        }

        public String pNameString() {
            return VkPipelineShaderStageCreateInfo.npNameString(this.address());
        }

        public VkSpecializationInfo pSpecializationInfo() {
            return VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address());
        }

        public Buffer sType(int value) {
            VkPipelineShaderStageCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkPipelineShaderStageCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkPipelineShaderStageCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer stage(int value) {
            VkPipelineShaderStageCreateInfo.nstage(this.address(), value);
            return this;
        }

        public Buffer module(long value) {
            VkPipelineShaderStageCreateInfo.nmodule(this.address(), value);
            return this;
        }

        public Buffer pName(ByteBuffer value) {
            VkPipelineShaderStageCreateInfo.npName(this.address(), value);
            return this;
        }

        public Buffer pSpecializationInfo(VkSpecializationInfo value) {
            VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address(), value);
            return this;
        }
    }
}

