/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkVertexInputAttributeDescription;
import org.lwjgl.vulkan.VkVertexInputBindingDescription;

public class VkPipelineVertexInputStateCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int VERTEXBINDINGDESCRIPTIONCOUNT;
    public static final int PVERTEXBINDINGDESCRIPTIONS;
    public static final int VERTEXATTRIBUTEDESCRIPTIONCOUNT;
    public static final int PVERTEXATTRIBUTEDESCRIPTIONS;

    VkPipelineVertexInputStateCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineVertexInputStateCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineVertexInputStateCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPipelineVertexInputStateCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkPipelineVertexInputStateCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkPipelineVertexInputStateCreateInfo.nflags(this.address());
    }

    public int vertexBindingDescriptionCount() {
        return VkPipelineVertexInputStateCreateInfo.nvertexBindingDescriptionCount(this.address());
    }

    public VkVertexInputBindingDescription.Buffer pVertexBindingDescriptions() {
        return VkPipelineVertexInputStateCreateInfo.npVertexBindingDescriptions(this.address());
    }

    public int vertexAttributeDescriptionCount() {
        return VkPipelineVertexInputStateCreateInfo.nvertexAttributeDescriptionCount(this.address());
    }

    public VkVertexInputAttributeDescription.Buffer pVertexAttributeDescriptions() {
        return VkPipelineVertexInputStateCreateInfo.npVertexAttributeDescriptions(this.address());
    }

    public VkPipelineVertexInputStateCreateInfo sType(int value) {
        VkPipelineVertexInputStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineVertexInputStateCreateInfo pNext(long value) {
        VkPipelineVertexInputStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineVertexInputStateCreateInfo flags(int value) {
        VkPipelineVertexInputStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineVertexInputStateCreateInfo pVertexBindingDescriptions(VkVertexInputBindingDescription.Buffer value) {
        VkPipelineVertexInputStateCreateInfo.npVertexBindingDescriptions(this.address(), value);
        return this;
    }

    public VkPipelineVertexInputStateCreateInfo pVertexAttributeDescriptions(VkVertexInputAttributeDescription.Buffer value) {
        VkPipelineVertexInputStateCreateInfo.npVertexAttributeDescriptions(this.address(), value);
        return this;
    }

    public VkPipelineVertexInputStateCreateInfo set(int sType, long pNext, int flags, VkVertexInputBindingDescription.Buffer pVertexBindingDescriptions, VkVertexInputAttributeDescription.Buffer pVertexAttributeDescriptions) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pVertexBindingDescriptions(pVertexBindingDescriptions);
        this.pVertexAttributeDescriptions(pVertexAttributeDescriptions);
        return this;
    }

    public VkPipelineVertexInputStateCreateInfo set(VkPipelineVertexInputStateCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineVertexInputStateCreateInfo malloc() {
        return VkPipelineVertexInputStateCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPipelineVertexInputStateCreateInfo calloc() {
        return VkPipelineVertexInputStateCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPipelineVertexInputStateCreateInfo create() {
        return new VkPipelineVertexInputStateCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineVertexInputStateCreateInfo create(long address) {
        return address == 0L ? null : new VkPipelineVertexInputStateCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineVertexInputStateCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineVertexInputStateCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPipelineVertexInputStateCreateInfo mallocStack() {
        return VkPipelineVertexInputStateCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineVertexInputStateCreateInfo callocStack() {
        return VkPipelineVertexInputStateCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineVertexInputStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineVertexInputStateCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineVertexInputStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineVertexInputStateCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineVertexInputStateCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineVertexInputStateCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineVertexInputStateCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineVertexInputStateCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nvertexBindingDescriptionCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXBINDINGDESCRIPTIONCOUNT);
    }

    public static VkVertexInputBindingDescription.Buffer npVertexBindingDescriptions(long struct) {
        return VkVertexInputBindingDescription.create(MemoryUtil.memGetAddress(struct + (long)PVERTEXBINDINGDESCRIPTIONS), VkPipelineVertexInputStateCreateInfo.nvertexBindingDescriptionCount(struct));
    }

    public static int nvertexAttributeDescriptionCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXATTRIBUTEDESCRIPTIONCOUNT);
    }

    public static VkVertexInputAttributeDescription.Buffer npVertexAttributeDescriptions(long struct) {
        return VkVertexInputAttributeDescription.create(MemoryUtil.memGetAddress(struct + (long)PVERTEXATTRIBUTEDESCRIPTIONS), VkPipelineVertexInputStateCreateInfo.nvertexAttributeDescriptionCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nvertexBindingDescriptionCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXBINDINGDESCRIPTIONCOUNT, value);
    }

    public static void npVertexBindingDescriptions(long struct, VkVertexInputBindingDescription.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVERTEXBINDINGDESCRIPTIONS, VkPipelineVertexInputStateCreateInfo.addressSafe(value));
        VkPipelineVertexInputStateCreateInfo.nvertexBindingDescriptionCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nvertexAttributeDescriptionCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXATTRIBUTEDESCRIPTIONCOUNT, value);
    }

    public static void npVertexAttributeDescriptions(long struct, VkVertexInputAttributeDescription.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVERTEXATTRIBUTEDESCRIPTIONS, VkPipelineVertexInputStateCreateInfo.addressSafe(value));
        VkPipelineVertexInputStateCreateInfo.nvertexAttributeDescriptionCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkPipelineVertexInputStateCreateInfo.nvertexBindingDescriptionCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PVERTEXBINDINGDESCRIPTIONS));
        }
        if (VkPipelineVertexInputStateCreateInfo.nvertexAttributeDescriptionCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PVERTEXATTRIBUTEDESCRIPTIONS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkPipelineVertexInputStateCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkPipelineVertexInputStateCreateInfo.__struct(VkPipelineVertexInputStateCreateInfo.__member(4), VkPipelineVertexInputStateCreateInfo.__member(POINTER_SIZE), VkPipelineVertexInputStateCreateInfo.__member(4), VkPipelineVertexInputStateCreateInfo.__member(4), VkPipelineVertexInputStateCreateInfo.__member(POINTER_SIZE), VkPipelineVertexInputStateCreateInfo.__member(4), VkPipelineVertexInputStateCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        VERTEXBINDINGDESCRIPTIONCOUNT = layout.offsetof(3);
        PVERTEXBINDINGDESCRIPTIONS = layout.offsetof(4);
        VERTEXATTRIBUTEDESCRIPTIONCOUNT = layout.offsetof(5);
        PVERTEXATTRIBUTEDESCRIPTIONS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineVertexInputStateCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineVertexInputStateCreateInfo newInstance(long address) {
            return new VkPipelineVertexInputStateCreateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPipelineVertexInputStateCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkPipelineVertexInputStateCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkPipelineVertexInputStateCreateInfo.nflags(this.address());
        }

        public int vertexBindingDescriptionCount() {
            return VkPipelineVertexInputStateCreateInfo.nvertexBindingDescriptionCount(this.address());
        }

        public VkVertexInputBindingDescription.Buffer pVertexBindingDescriptions() {
            return VkPipelineVertexInputStateCreateInfo.npVertexBindingDescriptions(this.address());
        }

        public int vertexAttributeDescriptionCount() {
            return VkPipelineVertexInputStateCreateInfo.nvertexAttributeDescriptionCount(this.address());
        }

        public VkVertexInputAttributeDescription.Buffer pVertexAttributeDescriptions() {
            return VkPipelineVertexInputStateCreateInfo.npVertexAttributeDescriptions(this.address());
        }

        public Buffer sType(int value) {
            VkPipelineVertexInputStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkPipelineVertexInputStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkPipelineVertexInputStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pVertexBindingDescriptions(VkVertexInputBindingDescription.Buffer value) {
            VkPipelineVertexInputStateCreateInfo.npVertexBindingDescriptions(this.address(), value);
            return this;
        }

        public Buffer pVertexAttributeDescriptions(VkVertexInputAttributeDescription.Buffer value) {
            VkPipelineVertexInputStateCreateInfo.npVertexAttributeDescriptions(this.address(), value);
            return this;
        }
    }
}

