/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;
import org.lwjgl.vulkan.VkViewport;

public class VkPipelineViewportStateCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int VIEWPORTCOUNT;
    public static final int PVIEWPORTS;
    public static final int SCISSORCOUNT;
    public static final int PSCISSORS;

    VkPipelineViewportStateCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineViewportStateCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineViewportStateCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPipelineViewportStateCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkPipelineViewportStateCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkPipelineViewportStateCreateInfo.nflags(this.address());
    }

    public int viewportCount() {
        return VkPipelineViewportStateCreateInfo.nviewportCount(this.address());
    }

    public VkViewport.Buffer pViewports() {
        return VkPipelineViewportStateCreateInfo.npViewports(this.address());
    }

    public int scissorCount() {
        return VkPipelineViewportStateCreateInfo.nscissorCount(this.address());
    }

    public VkRect2D.Buffer pScissors() {
        return VkPipelineViewportStateCreateInfo.npScissors(this.address());
    }

    public VkPipelineViewportStateCreateInfo sType(int value) {
        VkPipelineViewportStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo pNext(long value) {
        VkPipelineViewportStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo flags(int value) {
        VkPipelineViewportStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo viewportCount(int value) {
        VkPipelineViewportStateCreateInfo.nviewportCount(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo pViewports(VkViewport.Buffer value) {
        VkPipelineViewportStateCreateInfo.npViewports(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo scissorCount(int value) {
        VkPipelineViewportStateCreateInfo.nscissorCount(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo pScissors(VkRect2D.Buffer value) {
        VkPipelineViewportStateCreateInfo.npScissors(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo set(int sType, long pNext, int flags, int viewportCount, VkViewport.Buffer pViewports, int scissorCount, VkRect2D.Buffer pScissors) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.viewportCount(viewportCount);
        this.pViewports(pViewports);
        this.scissorCount(scissorCount);
        this.pScissors(pScissors);
        return this;
    }

    public VkPipelineViewportStateCreateInfo set(VkPipelineViewportStateCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineViewportStateCreateInfo malloc() {
        return VkPipelineViewportStateCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPipelineViewportStateCreateInfo calloc() {
        return VkPipelineViewportStateCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPipelineViewportStateCreateInfo create() {
        return new VkPipelineViewportStateCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineViewportStateCreateInfo create(long address) {
        return address == 0L ? null : new VkPipelineViewportStateCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineViewportStateCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineViewportStateCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPipelineViewportStateCreateInfo mallocStack() {
        return VkPipelineViewportStateCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineViewportStateCreateInfo callocStack() {
        return VkPipelineViewportStateCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineViewportStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineViewportStateCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineViewportStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineViewportStateCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineViewportStateCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineViewportStateCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineViewportStateCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineViewportStateCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nviewportCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWPORTCOUNT);
    }

    public static VkViewport.Buffer npViewports(long struct) {
        return VkViewport.create(MemoryUtil.memGetAddress(struct + (long)PVIEWPORTS), VkPipelineViewportStateCreateInfo.nviewportCount(struct));
    }

    public static int nscissorCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SCISSORCOUNT);
    }

    public static VkRect2D.Buffer npScissors(long struct) {
        return VkRect2D.create(MemoryUtil.memGetAddress(struct + (long)PSCISSORS), VkPipelineViewportStateCreateInfo.nscissorCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nviewportCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VIEWPORTCOUNT, value);
    }

    public static void npViewports(long struct, VkViewport.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWPORTS, VkPipelineViewportStateCreateInfo.addressSafe(value));
        if (value != null) {
            VkPipelineViewportStateCreateInfo.nviewportCount(struct, value.remaining());
        }
    }

    public static void nscissorCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SCISSORCOUNT, value);
    }

    public static void npScissors(long struct, VkRect2D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSCISSORS, VkPipelineViewportStateCreateInfo.addressSafe(value));
        if (value != null) {
            VkPipelineViewportStateCreateInfo.nscissorCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkPipelineViewportStateCreateInfo.__struct(VkPipelineViewportStateCreateInfo.__member(4), VkPipelineViewportStateCreateInfo.__member(POINTER_SIZE), VkPipelineViewportStateCreateInfo.__member(4), VkPipelineViewportStateCreateInfo.__member(4), VkPipelineViewportStateCreateInfo.__member(POINTER_SIZE), VkPipelineViewportStateCreateInfo.__member(4), VkPipelineViewportStateCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        VIEWPORTCOUNT = layout.offsetof(3);
        PVIEWPORTS = layout.offsetof(4);
        SCISSORCOUNT = layout.offsetof(5);
        PSCISSORS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineViewportStateCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineViewportStateCreateInfo newInstance(long address) {
            return new VkPipelineViewportStateCreateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPipelineViewportStateCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkPipelineViewportStateCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkPipelineViewportStateCreateInfo.nflags(this.address());
        }

        public int viewportCount() {
            return VkPipelineViewportStateCreateInfo.nviewportCount(this.address());
        }

        public VkViewport.Buffer pViewports() {
            return VkPipelineViewportStateCreateInfo.npViewports(this.address());
        }

        public int scissorCount() {
            return VkPipelineViewportStateCreateInfo.nscissorCount(this.address());
        }

        public VkRect2D.Buffer pScissors() {
            return VkPipelineViewportStateCreateInfo.npScissors(this.address());
        }

        public Buffer sType(int value) {
            VkPipelineViewportStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkPipelineViewportStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkPipelineViewportStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer viewportCount(int value) {
            VkPipelineViewportStateCreateInfo.nviewportCount(this.address(), value);
            return this;
        }

        public Buffer pViewports(VkViewport.Buffer value) {
            VkPipelineViewportStateCreateInfo.npViewports(this.address(), value);
            return this;
        }

        public Buffer scissorCount(int value) {
            VkPipelineViewportStateCreateInfo.nscissorCount(this.address(), value);
            return this;
        }

        public Buffer pScissors(VkRect2D.Buffer value) {
            VkPipelineViewportStateCreateInfo.npScissors(this.address(), value);
            return this;
        }
    }
}

