/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkViewportSwizzleNV;

public class VkPipelineViewportSwizzleStateCreateInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int VIEWPORTCOUNT;
    public static final int PVIEWPORTSWIZZLES;

    VkPipelineViewportSwizzleStateCreateInfoNV(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineViewportSwizzleStateCreateInfoNV.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.nsType(this.address());
    }

    public long pNext() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.npNext(this.address());
    }

    public int flags() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.nflags(this.address());
    }

    public int viewportCount() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.nviewportCount(this.address());
    }

    public VkViewportSwizzleNV.Buffer pViewportSwizzles() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.npViewportSwizzles(this.address());
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV sType(int value) {
        VkPipelineViewportSwizzleStateCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV pNext(long value) {
        VkPipelineViewportSwizzleStateCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV flags(int value) {
        VkPipelineViewportSwizzleStateCreateInfoNV.nflags(this.address(), value);
        return this;
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV viewportCount(int value) {
        VkPipelineViewportSwizzleStateCreateInfoNV.nviewportCount(this.address(), value);
        return this;
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV pViewportSwizzles(VkViewportSwizzleNV.Buffer value) {
        VkPipelineViewportSwizzleStateCreateInfoNV.npViewportSwizzles(this.address(), value);
        return this;
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV set(int sType, long pNext, int flags, int viewportCount, VkViewportSwizzleNV.Buffer pViewportSwizzles) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.viewportCount(viewportCount);
        this.pViewportSwizzles(pViewportSwizzles);
        return this;
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV set(VkPipelineViewportSwizzleStateCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV malloc() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV calloc() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV create() {
        return new VkPipelineViewportSwizzleStateCreateInfoNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV create(long address) {
        return address == 0L ? null : new VkPipelineViewportSwizzleStateCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV mallocStack() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV callocStack() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV mallocStack(MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV callocStack(MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nviewportCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWPORTCOUNT);
    }

    public static VkViewportSwizzleNV.Buffer npViewportSwizzles(long struct) {
        return VkViewportSwizzleNV.create(MemoryUtil.memGetAddress(struct + (long)PVIEWPORTSWIZZLES), VkPipelineViewportSwizzleStateCreateInfoNV.nviewportCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nviewportCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VIEWPORTCOUNT, value);
    }

    public static void npViewportSwizzles(long struct, VkViewportSwizzleNV.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWPORTSWIZZLES, VkPipelineViewportSwizzleStateCreateInfoNV.addressSafe(value));
        if (value != null) {
            VkPipelineViewportSwizzleStateCreateInfoNV.nviewportCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkPipelineViewportSwizzleStateCreateInfoNV.__struct(VkPipelineViewportSwizzleStateCreateInfoNV.__member(4), VkPipelineViewportSwizzleStateCreateInfoNV.__member(POINTER_SIZE), VkPipelineViewportSwizzleStateCreateInfoNV.__member(4), VkPipelineViewportSwizzleStateCreateInfoNV.__member(4), VkPipelineViewportSwizzleStateCreateInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        VIEWPORTCOUNT = layout.offsetof(3);
        PVIEWPORTSWIZZLES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineViewportSwizzleStateCreateInfoNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineViewportSwizzleStateCreateInfoNV newInstance(long address) {
            return new VkPipelineViewportSwizzleStateCreateInfoNV(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPipelineViewportSwizzleStateCreateInfoNV.nsType(this.address());
        }

        public long pNext() {
            return VkPipelineViewportSwizzleStateCreateInfoNV.npNext(this.address());
        }

        public int flags() {
            return VkPipelineViewportSwizzleStateCreateInfoNV.nflags(this.address());
        }

        public int viewportCount() {
            return VkPipelineViewportSwizzleStateCreateInfoNV.nviewportCount(this.address());
        }

        public VkViewportSwizzleNV.Buffer pViewportSwizzles() {
            return VkPipelineViewportSwizzleStateCreateInfoNV.npViewportSwizzles(this.address());
        }

        public Buffer sType(int value) {
            VkPipelineViewportSwizzleStateCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkPipelineViewportSwizzleStateCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkPipelineViewportSwizzleStateCreateInfoNV.nflags(this.address(), value);
            return this;
        }

        public Buffer viewportCount(int value) {
            VkPipelineViewportSwizzleStateCreateInfoNV.nviewportCount(this.address(), value);
            return this;
        }

        public Buffer pViewportSwizzles(VkViewportSwizzleNV.Buffer value) {
            VkPipelineViewportSwizzleStateCreateInfoNV.npViewportSwizzles(this.address(), value);
            return this;
        }
    }
}

