/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkViewportWScalingNV;

public class VkPipelineViewportWScalingStateCreateInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int VIEWPORTWSCALINGENABLE;
    public static final int VIEWPORTCOUNT;
    public static final int PVIEWPORTWSCALINGS;

    VkPipelineViewportWScalingStateCreateInfoNV(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineViewportWScalingStateCreateInfoNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineViewportWScalingStateCreateInfoNV.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPipelineViewportWScalingStateCreateInfoNV.nsType(this.address());
    }

    public long pNext() {
        return VkPipelineViewportWScalingStateCreateInfoNV.npNext(this.address());
    }

    public boolean viewportWScalingEnable() {
        return VkPipelineViewportWScalingStateCreateInfoNV.nviewportWScalingEnable(this.address()) != 0;
    }

    public int viewportCount() {
        return VkPipelineViewportWScalingStateCreateInfoNV.nviewportCount(this.address());
    }

    public VkViewportWScalingNV.Buffer pViewportWScalings() {
        return VkPipelineViewportWScalingStateCreateInfoNV.npViewportWScalings(this.address());
    }

    public VkPipelineViewportWScalingStateCreateInfoNV sType(int value) {
        VkPipelineViewportWScalingStateCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkPipelineViewportWScalingStateCreateInfoNV pNext(long value) {
        VkPipelineViewportWScalingStateCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkPipelineViewportWScalingStateCreateInfoNV viewportWScalingEnable(boolean value) {
        VkPipelineViewportWScalingStateCreateInfoNV.nviewportWScalingEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineViewportWScalingStateCreateInfoNV pViewportWScalings(VkViewportWScalingNV.Buffer value) {
        VkPipelineViewportWScalingStateCreateInfoNV.npViewportWScalings(this.address(), value);
        return this;
    }

    public VkPipelineViewportWScalingStateCreateInfoNV set(int sType, long pNext, boolean viewportWScalingEnable, VkViewportWScalingNV.Buffer pViewportWScalings) {
        this.sType(sType);
        this.pNext(pNext);
        this.viewportWScalingEnable(viewportWScalingEnable);
        this.pViewportWScalings(pViewportWScalings);
        return this;
    }

    public VkPipelineViewportWScalingStateCreateInfoNV set(VkPipelineViewportWScalingStateCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineViewportWScalingStateCreateInfoNV malloc() {
        return VkPipelineViewportWScalingStateCreateInfoNV.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPipelineViewportWScalingStateCreateInfoNV calloc() {
        return VkPipelineViewportWScalingStateCreateInfoNV.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPipelineViewportWScalingStateCreateInfoNV create() {
        return new VkPipelineViewportWScalingStateCreateInfoNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineViewportWScalingStateCreateInfoNV create(long address) {
        return address == 0L ? null : new VkPipelineViewportWScalingStateCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineViewportWScalingStateCreateInfoNV.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineViewportWScalingStateCreateInfoNV.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPipelineViewportWScalingStateCreateInfoNV mallocStack() {
        return VkPipelineViewportWScalingStateCreateInfoNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineViewportWScalingStateCreateInfoNV callocStack() {
        return VkPipelineViewportWScalingStateCreateInfoNV.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineViewportWScalingStateCreateInfoNV mallocStack(MemoryStack stack) {
        return VkPipelineViewportWScalingStateCreateInfoNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineViewportWScalingStateCreateInfoNV callocStack(MemoryStack stack) {
        return VkPipelineViewportWScalingStateCreateInfoNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineViewportWScalingStateCreateInfoNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineViewportWScalingStateCreateInfoNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineViewportWScalingStateCreateInfoNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineViewportWScalingStateCreateInfoNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nviewportWScalingEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWPORTWSCALINGENABLE);
    }

    public static int nviewportCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWPORTCOUNT);
    }

    public static VkViewportWScalingNV.Buffer npViewportWScalings(long struct) {
        return VkViewportWScalingNV.create(MemoryUtil.memGetAddress(struct + (long)PVIEWPORTWSCALINGS), VkPipelineViewportWScalingStateCreateInfoNV.nviewportCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nviewportWScalingEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VIEWPORTWSCALINGENABLE, value);
    }

    public static void nviewportCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VIEWPORTCOUNT, value);
    }

    public static void npViewportWScalings(long struct, VkViewportWScalingNV.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWPORTWSCALINGS, value.address());
        VkPipelineViewportWScalingStateCreateInfoNV.nviewportCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PVIEWPORTWSCALINGS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkPipelineViewportWScalingStateCreateInfoNV.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkPipelineViewportWScalingStateCreateInfoNV.__struct(VkPipelineViewportWScalingStateCreateInfoNV.__member(4), VkPipelineViewportWScalingStateCreateInfoNV.__member(POINTER_SIZE), VkPipelineViewportWScalingStateCreateInfoNV.__member(4), VkPipelineViewportWScalingStateCreateInfoNV.__member(4), VkPipelineViewportWScalingStateCreateInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        VIEWPORTWSCALINGENABLE = layout.offsetof(2);
        VIEWPORTCOUNT = layout.offsetof(3);
        PVIEWPORTWSCALINGS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineViewportWScalingStateCreateInfoNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineViewportWScalingStateCreateInfoNV newInstance(long address) {
            return new VkPipelineViewportWScalingStateCreateInfoNV(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPipelineViewportWScalingStateCreateInfoNV.nsType(this.address());
        }

        public long pNext() {
            return VkPipelineViewportWScalingStateCreateInfoNV.npNext(this.address());
        }

        public boolean viewportWScalingEnable() {
            return VkPipelineViewportWScalingStateCreateInfoNV.nviewportWScalingEnable(this.address()) != 0;
        }

        public int viewportCount() {
            return VkPipelineViewportWScalingStateCreateInfoNV.nviewportCount(this.address());
        }

        public VkViewportWScalingNV.Buffer pViewportWScalings() {
            return VkPipelineViewportWScalingStateCreateInfoNV.npViewportWScalings(this.address());
        }

        public Buffer sType(int value) {
            VkPipelineViewportWScalingStateCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkPipelineViewportWScalingStateCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer viewportWScalingEnable(boolean value) {
            VkPipelineViewportWScalingStateCreateInfoNV.nviewportWScalingEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer pViewportWScalings(VkViewportWScalingNV.Buffer value) {
            VkPipelineViewportWScalingStateCreateInfoNV.npViewportWScalings(this.address(), value);
            return this;
        }
    }
}

