/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPresentInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int WAITSEMAPHORECOUNT;
    public static final int PWAITSEMAPHORES;
    public static final int SWAPCHAINCOUNT;
    public static final int PSWAPCHAINS;
    public static final int PIMAGEINDICES;
    public static final int PRESULTS;

    VkPresentInfoKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPresentInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPresentInfoKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPresentInfoKHR.nsType(this.address());
    }

    public long pNext() {
        return VkPresentInfoKHR.npNext(this.address());
    }

    public int waitSemaphoreCount() {
        return VkPresentInfoKHR.nwaitSemaphoreCount(this.address());
    }

    public LongBuffer pWaitSemaphores() {
        return VkPresentInfoKHR.npWaitSemaphores(this.address());
    }

    public int swapchainCount() {
        return VkPresentInfoKHR.nswapchainCount(this.address());
    }

    public LongBuffer pSwapchains() {
        return VkPresentInfoKHR.npSwapchains(this.address());
    }

    public IntBuffer pImageIndices() {
        return VkPresentInfoKHR.npImageIndices(this.address());
    }

    public IntBuffer pResults() {
        return VkPresentInfoKHR.npResults(this.address());
    }

    public VkPresentInfoKHR sType(int value) {
        VkPresentInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pNext(long value) {
        VkPresentInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR waitSemaphoreCount(int value) {
        VkPresentInfoKHR.nwaitSemaphoreCount(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pWaitSemaphores(LongBuffer value) {
        VkPresentInfoKHR.npWaitSemaphores(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR swapchainCount(int value) {
        VkPresentInfoKHR.nswapchainCount(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pSwapchains(LongBuffer value) {
        VkPresentInfoKHR.npSwapchains(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pImageIndices(IntBuffer value) {
        VkPresentInfoKHR.npImageIndices(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pResults(IntBuffer value) {
        VkPresentInfoKHR.npResults(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR set(int sType, long pNext, int waitSemaphoreCount, LongBuffer pWaitSemaphores, int swapchainCount, LongBuffer pSwapchains, IntBuffer pImageIndices, IntBuffer pResults) {
        this.sType(sType);
        this.pNext(pNext);
        this.waitSemaphoreCount(waitSemaphoreCount);
        this.pWaitSemaphores(pWaitSemaphores);
        this.swapchainCount(swapchainCount);
        this.pSwapchains(pSwapchains);
        this.pImageIndices(pImageIndices);
        this.pResults(pResults);
        return this;
    }

    public VkPresentInfoKHR set(VkPresentInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPresentInfoKHR malloc() {
        return VkPresentInfoKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPresentInfoKHR calloc() {
        return VkPresentInfoKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPresentInfoKHR create() {
        return new VkPresentInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPresentInfoKHR create(long address) {
        return address == 0L ? null : new VkPresentInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPresentInfoKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPresentInfoKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPresentInfoKHR mallocStack() {
        return VkPresentInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkPresentInfoKHR callocStack() {
        return VkPresentInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkPresentInfoKHR mallocStack(MemoryStack stack) {
        return VkPresentInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPresentInfoKHR callocStack(MemoryStack stack) {
        return VkPresentInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPresentInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPresentInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPresentInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPresentInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nwaitSemaphoreCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WAITSEMAPHORECOUNT);
    }

    public static LongBuffer npWaitSemaphores(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHORES), VkPresentInfoKHR.nwaitSemaphoreCount(struct));
    }

    public static int nswapchainCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SWAPCHAINCOUNT);
    }

    public static LongBuffer npSwapchains(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PSWAPCHAINS), VkPresentInfoKHR.nswapchainCount(struct));
    }

    public static IntBuffer npImageIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PIMAGEINDICES), VkPresentInfoKHR.nswapchainCount(struct));
    }

    public static IntBuffer npResults(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PRESULTS), VkPresentInfoKHR.nswapchainCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nwaitSemaphoreCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WAITSEMAPHORECOUNT, value);
    }

    public static void npWaitSemaphores(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PWAITSEMAPHORES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkPresentInfoKHR.nwaitSemaphoreCount(struct, value.remaining());
        }
    }

    public static void nswapchainCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SWAPCHAINCOUNT, value);
    }

    public static void npSwapchains(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSWAPCHAINS, MemoryUtil.memAddress(value));
    }

    public static void npImageIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PIMAGEINDICES, MemoryUtil.memAddress(value));
    }

    public static void npResults(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PRESULTS, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSWAPCHAINS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PIMAGEINDICES));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkPresentInfoKHR.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkPresentInfoKHR.__struct(VkPresentInfoKHR.__member(4), VkPresentInfoKHR.__member(POINTER_SIZE), VkPresentInfoKHR.__member(4), VkPresentInfoKHR.__member(POINTER_SIZE), VkPresentInfoKHR.__member(4), VkPresentInfoKHR.__member(POINTER_SIZE), VkPresentInfoKHR.__member(POINTER_SIZE), VkPresentInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        WAITSEMAPHORECOUNT = layout.offsetof(2);
        PWAITSEMAPHORES = layout.offsetof(3);
        SWAPCHAINCOUNT = layout.offsetof(4);
        PSWAPCHAINS = layout.offsetof(5);
        PIMAGEINDICES = layout.offsetof(6);
        PRESULTS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkPresentInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPresentInfoKHR newInstance(long address) {
            return new VkPresentInfoKHR(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPresentInfoKHR.nsType(this.address());
        }

        public long pNext() {
            return VkPresentInfoKHR.npNext(this.address());
        }

        public int waitSemaphoreCount() {
            return VkPresentInfoKHR.nwaitSemaphoreCount(this.address());
        }

        public LongBuffer pWaitSemaphores() {
            return VkPresentInfoKHR.npWaitSemaphores(this.address());
        }

        public int swapchainCount() {
            return VkPresentInfoKHR.nswapchainCount(this.address());
        }

        public LongBuffer pSwapchains() {
            return VkPresentInfoKHR.npSwapchains(this.address());
        }

        public IntBuffer pImageIndices() {
            return VkPresentInfoKHR.npImageIndices(this.address());
        }

        public IntBuffer pResults() {
            return VkPresentInfoKHR.npResults(this.address());
        }

        public Buffer sType(int value) {
            VkPresentInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkPresentInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer waitSemaphoreCount(int value) {
            VkPresentInfoKHR.nwaitSemaphoreCount(this.address(), value);
            return this;
        }

        public Buffer pWaitSemaphores(LongBuffer value) {
            VkPresentInfoKHR.npWaitSemaphores(this.address(), value);
            return this;
        }

        public Buffer swapchainCount(int value) {
            VkPresentInfoKHR.nswapchainCount(this.address(), value);
            return this;
        }

        public Buffer pSwapchains(LongBuffer value) {
            VkPresentInfoKHR.npSwapchains(this.address(), value);
            return this;
        }

        public Buffer pImageIndices(IntBuffer value) {
            VkPresentInfoKHR.npImageIndices(this.address(), value);
            return this;
        }

        public Buffer pResults(IntBuffer value) {
            VkPresentInfoKHR.npResults(this.address(), value);
            return this;
        }
    }
}

