/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPresentTimeGOOGLE
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PRESENTID;
    public static final int DESIREDPRESENTTIME;

    VkPresentTimeGOOGLE(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPresentTimeGOOGLE(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPresentTimeGOOGLE.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int presentID() {
        return VkPresentTimeGOOGLE.npresentID(this.address());
    }

    public long desiredPresentTime() {
        return VkPresentTimeGOOGLE.ndesiredPresentTime(this.address());
    }

    public VkPresentTimeGOOGLE presentID(int value) {
        VkPresentTimeGOOGLE.npresentID(this.address(), value);
        return this;
    }

    public VkPresentTimeGOOGLE desiredPresentTime(long value) {
        VkPresentTimeGOOGLE.ndesiredPresentTime(this.address(), value);
        return this;
    }

    public VkPresentTimeGOOGLE set(int presentID, long desiredPresentTime) {
        this.presentID(presentID);
        this.desiredPresentTime(desiredPresentTime);
        return this;
    }

    public VkPresentTimeGOOGLE set(VkPresentTimeGOOGLE src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPresentTimeGOOGLE malloc() {
        return VkPresentTimeGOOGLE.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPresentTimeGOOGLE calloc() {
        return VkPresentTimeGOOGLE.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPresentTimeGOOGLE create() {
        return new VkPresentTimeGOOGLE(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPresentTimeGOOGLE create(long address) {
        return address == 0L ? null : new VkPresentTimeGOOGLE(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPresentTimeGOOGLE.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPresentTimeGOOGLE.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPresentTimeGOOGLE mallocStack() {
        return VkPresentTimeGOOGLE.mallocStack(MemoryStack.stackGet());
    }

    public static VkPresentTimeGOOGLE callocStack() {
        return VkPresentTimeGOOGLE.callocStack(MemoryStack.stackGet());
    }

    public static VkPresentTimeGOOGLE mallocStack(MemoryStack stack) {
        return VkPresentTimeGOOGLE.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPresentTimeGOOGLE callocStack(MemoryStack stack) {
        return VkPresentTimeGOOGLE.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPresentTimeGOOGLE.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPresentTimeGOOGLE.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPresentTimeGOOGLE.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPresentTimeGOOGLE.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int npresentID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRESENTID);
    }

    public static long ndesiredPresentTime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DESIREDPRESENTTIME);
    }

    public static void npresentID(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PRESENTID, value);
    }

    public static void ndesiredPresentTime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DESIREDPRESENTTIME, value);
    }

    static {
        Struct.Layout layout = VkPresentTimeGOOGLE.__struct(VkPresentTimeGOOGLE.__member(4), VkPresentTimeGOOGLE.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PRESENTID = layout.offsetof(0);
        DESIREDPRESENTTIME = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkPresentTimeGOOGLE, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPresentTimeGOOGLE newInstance(long address) {
            return new VkPresentTimeGOOGLE(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int presentID() {
            return VkPresentTimeGOOGLE.npresentID(this.address());
        }

        public long desiredPresentTime() {
            return VkPresentTimeGOOGLE.ndesiredPresentTime(this.address());
        }

        public Buffer presentID(int value) {
            VkPresentTimeGOOGLE.npresentID(this.address(), value);
            return this;
        }

        public Buffer desiredPresentTime(long value) {
            VkPresentTimeGOOGLE.ndesiredPresentTime(this.address(), value);
            return this;
        }
    }
}

