/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPushConstantRange
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STAGEFLAGS;
    public static final int OFFSET;
    public static final int SIZE;

    VkPushConstantRange(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPushConstantRange(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPushConstantRange.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int stageFlags() {
        return VkPushConstantRange.nstageFlags(this.address());
    }

    public int offset() {
        return VkPushConstantRange.noffset(this.address());
    }

    public int size() {
        return VkPushConstantRange.nsize(this.address());
    }

    public VkPushConstantRange stageFlags(int value) {
        VkPushConstantRange.nstageFlags(this.address(), value);
        return this;
    }

    public VkPushConstantRange offset(int value) {
        VkPushConstantRange.noffset(this.address(), value);
        return this;
    }

    public VkPushConstantRange size(int value) {
        VkPushConstantRange.nsize(this.address(), value);
        return this;
    }

    public VkPushConstantRange set(int stageFlags, int offset, int size) {
        this.stageFlags(stageFlags);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkPushConstantRange set(VkPushConstantRange src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPushConstantRange malloc() {
        return VkPushConstantRange.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPushConstantRange calloc() {
        return VkPushConstantRange.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPushConstantRange create() {
        return new VkPushConstantRange(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPushConstantRange create(long address) {
        return address == 0L ? null : new VkPushConstantRange(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPushConstantRange.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPushConstantRange.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPushConstantRange mallocStack() {
        return VkPushConstantRange.mallocStack(MemoryStack.stackGet());
    }

    public static VkPushConstantRange callocStack() {
        return VkPushConstantRange.callocStack(MemoryStack.stackGet());
    }

    public static VkPushConstantRange mallocStack(MemoryStack stack) {
        return VkPushConstantRange.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPushConstantRange callocStack(MemoryStack stack) {
        return VkPushConstantRange.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPushConstantRange.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPushConstantRange.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPushConstantRange.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPushConstantRange.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstageFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STAGEFLAGS);
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OFFSET);
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static void nstageFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STAGEFLAGS, value);
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkPushConstantRange.__struct(VkPushConstantRange.__member(4), VkPushConstantRange.__member(4), VkPushConstantRange.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STAGEFLAGS = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPushConstantRange, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPushConstantRange newInstance(long address) {
            return new VkPushConstantRange(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int stageFlags() {
            return VkPushConstantRange.nstageFlags(this.address());
        }

        public int offset() {
            return VkPushConstantRange.noffset(this.address());
        }

        public int size() {
            return VkPushConstantRange.nsize(this.address());
        }

        public Buffer stageFlags(int value) {
            VkPushConstantRange.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer offset(int value) {
            VkPushConstantRange.noffset(this.address(), value);
            return this;
        }

        public Buffer size(int value) {
            VkPushConstantRange.nsize(this.address(), value);
            return this;
        }
    }
}

