/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkRenderPassMultiviewCreateInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SUBPASSCOUNT;
    public static final int PVIEWMASKS;
    public static final int DEPENDENCYCOUNT;
    public static final int PVIEWOFFSETS;
    public static final int CORRELATIONMASKCOUNT;
    public static final int PCORRELATIONMASKS;

    VkRenderPassMultiviewCreateInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkRenderPassMultiviewCreateInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkRenderPassMultiviewCreateInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkRenderPassMultiviewCreateInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkRenderPassMultiviewCreateInfoKHX.npNext(this.address());
    }

    public int subpassCount() {
        return VkRenderPassMultiviewCreateInfoKHX.nsubpassCount(this.address());
    }

    public IntBuffer pViewMasks() {
        return VkRenderPassMultiviewCreateInfoKHX.npViewMasks(this.address());
    }

    public int dependencyCount() {
        return VkRenderPassMultiviewCreateInfoKHX.ndependencyCount(this.address());
    }

    public IntBuffer pViewOffsets() {
        return VkRenderPassMultiviewCreateInfoKHX.npViewOffsets(this.address());
    }

    public int correlationMaskCount() {
        return VkRenderPassMultiviewCreateInfoKHX.ncorrelationMaskCount(this.address());
    }

    public IntBuffer pCorrelationMasks() {
        return VkRenderPassMultiviewCreateInfoKHX.npCorrelationMasks(this.address());
    }

    public VkRenderPassMultiviewCreateInfoKHX sType(int value) {
        VkRenderPassMultiviewCreateInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfoKHX pNext(long value) {
        VkRenderPassMultiviewCreateInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfoKHX pViewMasks(IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHX.npViewMasks(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfoKHX pViewOffsets(IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHX.npViewOffsets(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfoKHX pCorrelationMasks(IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHX.npCorrelationMasks(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfoKHX set(int sType, long pNext, IntBuffer pViewMasks, IntBuffer pViewOffsets, IntBuffer pCorrelationMasks) {
        this.sType(sType);
        this.pNext(pNext);
        this.pViewMasks(pViewMasks);
        this.pViewOffsets(pViewOffsets);
        this.pCorrelationMasks(pCorrelationMasks);
        return this;
    }

    public VkRenderPassMultiviewCreateInfoKHX set(VkRenderPassMultiviewCreateInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderPassMultiviewCreateInfoKHX malloc() {
        return VkRenderPassMultiviewCreateInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHX calloc() {
        return VkRenderPassMultiviewCreateInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHX create() {
        return new VkRenderPassMultiviewCreateInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHX create(long address) {
        return address == 0L ? null : new VkRenderPassMultiviewCreateInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkRenderPassMultiviewCreateInfoKHX mallocStack() {
        return VkRenderPassMultiviewCreateInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassMultiviewCreateInfoKHX callocStack() {
        return VkRenderPassMultiviewCreateInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassMultiviewCreateInfoKHX mallocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHX callocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsubpassCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPASSCOUNT);
    }

    public static IntBuffer npViewMasks(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PVIEWMASKS), VkRenderPassMultiviewCreateInfoKHX.nsubpassCount(struct));
    }

    public static int ndependencyCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPENDENCYCOUNT);
    }

    public static IntBuffer npViewOffsets(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PVIEWOFFSETS), VkRenderPassMultiviewCreateInfoKHX.ndependencyCount(struct));
    }

    public static int ncorrelationMaskCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CORRELATIONMASKCOUNT);
    }

    public static IntBuffer npCorrelationMasks(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PCORRELATIONMASKS), VkRenderPassMultiviewCreateInfoKHX.ncorrelationMaskCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsubpassCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBPASSCOUNT, value);
    }

    public static void npViewMasks(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWMASKS, MemoryUtil.memAddressSafe(value));
        VkRenderPassMultiviewCreateInfoKHX.nsubpassCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ndependencyCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPENDENCYCOUNT, value);
    }

    public static void npViewOffsets(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWOFFSETS, MemoryUtil.memAddressSafe(value));
        VkRenderPassMultiviewCreateInfoKHX.ndependencyCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncorrelationMaskCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CORRELATIONMASKCOUNT, value);
    }

    public static void npCorrelationMasks(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCORRELATIONMASKS, MemoryUtil.memAddressSafe(value));
        VkRenderPassMultiviewCreateInfoKHX.ncorrelationMaskCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassMultiviewCreateInfoKHX.nsubpassCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PVIEWMASKS));
        }
        if (VkRenderPassMultiviewCreateInfoKHX.ndependencyCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PVIEWOFFSETS));
        }
        if (VkRenderPassMultiviewCreateInfoKHX.ncorrelationMaskCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCORRELATIONMASKS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkRenderPassMultiviewCreateInfoKHX.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkRenderPassMultiviewCreateInfoKHX.__struct(VkRenderPassMultiviewCreateInfoKHX.__member(4), VkRenderPassMultiviewCreateInfoKHX.__member(POINTER_SIZE), VkRenderPassMultiviewCreateInfoKHX.__member(4), VkRenderPassMultiviewCreateInfoKHX.__member(POINTER_SIZE), VkRenderPassMultiviewCreateInfoKHX.__member(4), VkRenderPassMultiviewCreateInfoKHX.__member(POINTER_SIZE), VkRenderPassMultiviewCreateInfoKHX.__member(4), VkRenderPassMultiviewCreateInfoKHX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SUBPASSCOUNT = layout.offsetof(2);
        PVIEWMASKS = layout.offsetof(3);
        DEPENDENCYCOUNT = layout.offsetof(4);
        PVIEWOFFSETS = layout.offsetof(5);
        CORRELATIONMASKCOUNT = layout.offsetof(6);
        PCORRELATIONMASKS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassMultiviewCreateInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkRenderPassMultiviewCreateInfoKHX newInstance(long address) {
            return new VkRenderPassMultiviewCreateInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkRenderPassMultiviewCreateInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkRenderPassMultiviewCreateInfoKHX.npNext(this.address());
        }

        public int subpassCount() {
            return VkRenderPassMultiviewCreateInfoKHX.nsubpassCount(this.address());
        }

        public IntBuffer pViewMasks() {
            return VkRenderPassMultiviewCreateInfoKHX.npViewMasks(this.address());
        }

        public int dependencyCount() {
            return VkRenderPassMultiviewCreateInfoKHX.ndependencyCount(this.address());
        }

        public IntBuffer pViewOffsets() {
            return VkRenderPassMultiviewCreateInfoKHX.npViewOffsets(this.address());
        }

        public int correlationMaskCount() {
            return VkRenderPassMultiviewCreateInfoKHX.ncorrelationMaskCount(this.address());
        }

        public IntBuffer pCorrelationMasks() {
            return VkRenderPassMultiviewCreateInfoKHX.npCorrelationMasks(this.address());
        }

        public Buffer sType(int value) {
            VkRenderPassMultiviewCreateInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkRenderPassMultiviewCreateInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer pViewMasks(IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHX.npViewMasks(this.address(), value);
            return this;
        }

        public Buffer pViewOffsets(IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHX.npViewOffsets(this.address(), value);
            return this;
        }

        public Buffer pCorrelationMasks(IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHX.npCorrelationMasks(this.address(), value);
            return this;
        }
    }
}

