/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkShaderModuleCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int CODESIZE;
    public static final int PCODE;

    VkShaderModuleCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkShaderModuleCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkShaderModuleCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkShaderModuleCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkShaderModuleCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkShaderModuleCreateInfo.nflags(this.address());
    }

    public long codeSize() {
        return VkShaderModuleCreateInfo.ncodeSize(this.address());
    }

    public ByteBuffer pCode() {
        return VkShaderModuleCreateInfo.npCode(this.address());
    }

    public VkShaderModuleCreateInfo sType(int value) {
        VkShaderModuleCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkShaderModuleCreateInfo pNext(long value) {
        VkShaderModuleCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkShaderModuleCreateInfo flags(int value) {
        VkShaderModuleCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkShaderModuleCreateInfo pCode(ByteBuffer value) {
        VkShaderModuleCreateInfo.npCode(this.address(), value);
        return this;
    }

    public VkShaderModuleCreateInfo set(int sType, long pNext, int flags, ByteBuffer pCode) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pCode(pCode);
        return this;
    }

    public VkShaderModuleCreateInfo set(VkShaderModuleCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkShaderModuleCreateInfo malloc() {
        return VkShaderModuleCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkShaderModuleCreateInfo calloc() {
        return VkShaderModuleCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkShaderModuleCreateInfo create() {
        return new VkShaderModuleCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkShaderModuleCreateInfo create(long address) {
        return address == 0L ? null : new VkShaderModuleCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkShaderModuleCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkShaderModuleCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkShaderModuleCreateInfo mallocStack() {
        return VkShaderModuleCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkShaderModuleCreateInfo callocStack() {
        return VkShaderModuleCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkShaderModuleCreateInfo mallocStack(MemoryStack stack) {
        return VkShaderModuleCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkShaderModuleCreateInfo callocStack(MemoryStack stack) {
        return VkShaderModuleCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkShaderModuleCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkShaderModuleCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkShaderModuleCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkShaderModuleCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long ncodeSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CODESIZE);
    }

    public static ByteBuffer npCode(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PCODE), (int)VkShaderModuleCreateInfo.ncodeSize(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ncodeSize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CODESIZE, value);
    }

    public static void npCode(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCODE, MemoryUtil.memAddress(value));
        VkShaderModuleCreateInfo.ncodeSize(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCODE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkShaderModuleCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkShaderModuleCreateInfo.__struct(VkShaderModuleCreateInfo.__member(4), VkShaderModuleCreateInfo.__member(POINTER_SIZE), VkShaderModuleCreateInfo.__member(4), VkShaderModuleCreateInfo.__member(POINTER_SIZE), VkShaderModuleCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        CODESIZE = layout.offsetof(3);
        PCODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkShaderModuleCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkShaderModuleCreateInfo newInstance(long address) {
            return new VkShaderModuleCreateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkShaderModuleCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkShaderModuleCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkShaderModuleCreateInfo.nflags(this.address());
        }

        public long codeSize() {
            return VkShaderModuleCreateInfo.ncodeSize(this.address());
        }

        public ByteBuffer pCode() {
            return VkShaderModuleCreateInfo.npCode(this.address());
        }

        public Buffer sType(int value) {
            VkShaderModuleCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkShaderModuleCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkShaderModuleCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pCode(ByteBuffer value) {
            VkShaderModuleCreateInfo.npCode(this.address(), value);
            return this;
        }
    }
}

