/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseImageFormatProperties;

public class VkSparseImageMemoryRequirements
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMATPROPERTIES;
    public static final int IMAGEMIPTAILFIRSTLOD;
    public static final int IMAGEMIPTAILSIZE;
    public static final int IMAGEMIPTAILOFFSET;
    public static final int IMAGEMIPTAILSTRIDE;

    VkSparseImageMemoryRequirements(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSparseImageMemoryRequirements(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSparseImageMemoryRequirements.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkSparseImageFormatProperties formatProperties() {
        return VkSparseImageMemoryRequirements.nformatProperties(this.address());
    }

    public int imageMipTailFirstLod() {
        return VkSparseImageMemoryRequirements.nimageMipTailFirstLod(this.address());
    }

    public long imageMipTailSize() {
        return VkSparseImageMemoryRequirements.nimageMipTailSize(this.address());
    }

    public long imageMipTailOffset() {
        return VkSparseImageMemoryRequirements.nimageMipTailOffset(this.address());
    }

    public long imageMipTailStride() {
        return VkSparseImageMemoryRequirements.nimageMipTailStride(this.address());
    }

    public static VkSparseImageMemoryRequirements malloc() {
        return VkSparseImageMemoryRequirements.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSparseImageMemoryRequirements calloc() {
        return VkSparseImageMemoryRequirements.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSparseImageMemoryRequirements create() {
        return new VkSparseImageMemoryRequirements(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSparseImageMemoryRequirements create(long address) {
        return address == 0L ? null : new VkSparseImageMemoryRequirements(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseImageMemoryRequirements.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseImageMemoryRequirements.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSparseImageMemoryRequirements mallocStack() {
        return VkSparseImageMemoryRequirements.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryRequirements callocStack() {
        return VkSparseImageMemoryRequirements.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryRequirements mallocStack(MemoryStack stack) {
        return VkSparseImageMemoryRequirements.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageMemoryRequirements callocStack(MemoryStack stack) {
        return VkSparseImageMemoryRequirements.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseImageMemoryRequirements.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseImageMemoryRequirements.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkSparseImageFormatProperties nformatProperties(long struct) {
        return VkSparseImageFormatProperties.create(struct + (long)FORMATPROPERTIES);
    }

    public static int nimageMipTailFirstLod(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGEMIPTAILFIRSTLOD);
    }

    public static long nimageMipTailSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGEMIPTAILSIZE);
    }

    public static long nimageMipTailOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGEMIPTAILOFFSET);
    }

    public static long nimageMipTailStride(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGEMIPTAILSTRIDE);
    }

    static {
        Struct.Layout layout = VkSparseImageMemoryRequirements.__struct(VkSparseImageMemoryRequirements.__member(VkSparseImageFormatProperties.SIZEOF, VkSparseImageFormatProperties.ALIGNOF), VkSparseImageMemoryRequirements.__member(4), VkSparseImageMemoryRequirements.__member(8), VkSparseImageMemoryRequirements.__member(8), VkSparseImageMemoryRequirements.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMATPROPERTIES = layout.offsetof(0);
        IMAGEMIPTAILFIRSTLOD = layout.offsetof(1);
        IMAGEMIPTAILSIZE = layout.offsetof(2);
        IMAGEMIPTAILOFFSET = layout.offsetof(3);
        IMAGEMIPTAILSTRIDE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageMemoryRequirements, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSparseImageMemoryRequirements newInstance(long address) {
            return new VkSparseImageMemoryRequirements(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public VkSparseImageFormatProperties formatProperties() {
            return VkSparseImageMemoryRequirements.nformatProperties(this.address());
        }

        public int imageMipTailFirstLod() {
            return VkSparseImageMemoryRequirements.nimageMipTailFirstLod(this.address());
        }

        public long imageMipTailSize() {
            return VkSparseImageMemoryRequirements.nimageMipTailSize(this.address());
        }

        public long imageMipTailOffset() {
            return VkSparseImageMemoryRequirements.nimageMipTailOffset(this.address());
        }

        public long imageMipTailStride() {
            return VkSparseImageMemoryRequirements.nimageMipTailStride(this.address());
        }
    }
}

