/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSpecializationMapEntry;

public class VkSpecializationInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAPENTRYCOUNT;
    public static final int PMAPENTRIES;
    public static final int DATASIZE;
    public static final int PDATA;

    VkSpecializationInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSpecializationInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSpecializationInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int mapEntryCount() {
        return VkSpecializationInfo.nmapEntryCount(this.address());
    }

    public VkSpecializationMapEntry.Buffer pMapEntries() {
        return VkSpecializationInfo.npMapEntries(this.address());
    }

    public long dataSize() {
        return VkSpecializationInfo.ndataSize(this.address());
    }

    public ByteBuffer pData() {
        return VkSpecializationInfo.npData(this.address());
    }

    public VkSpecializationInfo pMapEntries(VkSpecializationMapEntry.Buffer value) {
        VkSpecializationInfo.npMapEntries(this.address(), value);
        return this;
    }

    public VkSpecializationInfo pData(ByteBuffer value) {
        VkSpecializationInfo.npData(this.address(), value);
        return this;
    }

    public VkSpecializationInfo set(VkSpecializationMapEntry.Buffer pMapEntries, ByteBuffer pData) {
        this.pMapEntries(pMapEntries);
        this.pData(pData);
        return this;
    }

    public VkSpecializationInfo set(VkSpecializationInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSpecializationInfo malloc() {
        return VkSpecializationInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSpecializationInfo calloc() {
        return VkSpecializationInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSpecializationInfo create() {
        return new VkSpecializationInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSpecializationInfo create(long address) {
        return address == 0L ? null : new VkSpecializationInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSpecializationInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSpecializationInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSpecializationInfo mallocStack() {
        return VkSpecializationInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSpecializationInfo callocStack() {
        return VkSpecializationInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSpecializationInfo mallocStack(MemoryStack stack) {
        return VkSpecializationInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSpecializationInfo callocStack(MemoryStack stack) {
        return VkSpecializationInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSpecializationInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSpecializationInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSpecializationInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSpecializationInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmapEntryCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAPENTRYCOUNT);
    }

    public static VkSpecializationMapEntry.Buffer npMapEntries(long struct) {
        return VkSpecializationMapEntry.create(MemoryUtil.memGetAddress(struct + (long)PMAPENTRIES), VkSpecializationInfo.nmapEntryCount(struct));
    }

    public static long ndataSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DATASIZE);
    }

    public static ByteBuffer npData(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PDATA), (int)VkSpecializationInfo.ndataSize(struct));
    }

    public static void nmapEntryCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAPENTRYCOUNT, value);
    }

    public static void npMapEntries(long struct, VkSpecializationMapEntry.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PMAPENTRIES, VkSpecializationInfo.addressSafe(value));
        VkSpecializationInfo.nmapEntryCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ndataSize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DATASIZE, value);
    }

    public static void npData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDATA, MemoryUtil.memAddressSafe(value));
        VkSpecializationInfo.ndataSize(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void validate(long struct) {
        if (VkSpecializationInfo.nmapEntryCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PMAPENTRIES));
        }
        if (VkSpecializationInfo.ndataSize(struct) != 0L) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDATA));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSpecializationInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkSpecializationInfo.__struct(VkSpecializationInfo.__member(4), VkSpecializationInfo.__member(POINTER_SIZE), VkSpecializationInfo.__member(POINTER_SIZE), VkSpecializationInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAPENTRYCOUNT = layout.offsetof(0);
        PMAPENTRIES = layout.offsetof(1);
        DATASIZE = layout.offsetof(2);
        PDATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkSpecializationInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSpecializationInfo newInstance(long address) {
            return new VkSpecializationInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int mapEntryCount() {
            return VkSpecializationInfo.nmapEntryCount(this.address());
        }

        public VkSpecializationMapEntry.Buffer pMapEntries() {
            return VkSpecializationInfo.npMapEntries(this.address());
        }

        public long dataSize() {
            return VkSpecializationInfo.ndataSize(this.address());
        }

        public ByteBuffer pData() {
            return VkSpecializationInfo.npData(this.address());
        }

        public Buffer pMapEntries(VkSpecializationMapEntry.Buffer value) {
            VkSpecializationInfo.npMapEntries(this.address(), value);
            return this;
        }

        public Buffer pData(ByteBuffer value) {
            VkSpecializationInfo.npData(this.address(), value);
            return this;
        }
    }
}

