/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSpecializationMapEntry
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONSTANTID;
    public static final int OFFSET;
    public static final int SIZE;

    VkSpecializationMapEntry(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSpecializationMapEntry(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSpecializationMapEntry.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int constantID() {
        return VkSpecializationMapEntry.nconstantID(this.address());
    }

    public int offset() {
        return VkSpecializationMapEntry.noffset(this.address());
    }

    public long size() {
        return VkSpecializationMapEntry.nsize(this.address());
    }

    public VkSpecializationMapEntry constantID(int value) {
        VkSpecializationMapEntry.nconstantID(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry offset(int value) {
        VkSpecializationMapEntry.noffset(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry size(long value) {
        VkSpecializationMapEntry.nsize(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry set(int constantID, int offset, long size) {
        this.constantID(constantID);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkSpecializationMapEntry set(VkSpecializationMapEntry src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSpecializationMapEntry malloc() {
        return VkSpecializationMapEntry.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSpecializationMapEntry calloc() {
        return VkSpecializationMapEntry.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSpecializationMapEntry create() {
        return new VkSpecializationMapEntry(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSpecializationMapEntry create(long address) {
        return address == 0L ? null : new VkSpecializationMapEntry(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSpecializationMapEntry.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSpecializationMapEntry.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSpecializationMapEntry mallocStack() {
        return VkSpecializationMapEntry.mallocStack(MemoryStack.stackGet());
    }

    public static VkSpecializationMapEntry callocStack() {
        return VkSpecializationMapEntry.callocStack(MemoryStack.stackGet());
    }

    public static VkSpecializationMapEntry mallocStack(MemoryStack stack) {
        return VkSpecializationMapEntry.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSpecializationMapEntry callocStack(MemoryStack stack) {
        return VkSpecializationMapEntry.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSpecializationMapEntry.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSpecializationMapEntry.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSpecializationMapEntry.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSpecializationMapEntry.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nconstantID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONSTANTID);
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static void nconstantID(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONSTANTID, value);
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkSpecializationMapEntry.__struct(VkSpecializationMapEntry.__member(4), VkSpecializationMapEntry.__member(4), VkSpecializationMapEntry.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONSTANTID = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSpecializationMapEntry, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSpecializationMapEntry newInstance(long address) {
            return new VkSpecializationMapEntry(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int constantID() {
            return VkSpecializationMapEntry.nconstantID(this.address());
        }

        public int offset() {
            return VkSpecializationMapEntry.noffset(this.address());
        }

        public long size() {
            return VkSpecializationMapEntry.nsize(this.address());
        }

        public Buffer constantID(int value) {
            VkSpecializationMapEntry.nconstantID(this.address(), value);
            return this;
        }

        public Buffer offset(int value) {
            VkSpecializationMapEntry.noffset(this.address(), value);
            return this;
        }

        public Buffer size(long value) {
            VkSpecializationMapEntry.nsize(this.address(), value);
            return this;
        }
    }
}

