/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkStencilOpState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FAILOP;
    public static final int PASSOP;
    public static final int DEPTHFAILOP;
    public static final int COMPAREOP;
    public static final int COMPAREMASK;
    public static final int WRITEMASK;
    public static final int REFERENCE;

    VkStencilOpState(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkStencilOpState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkStencilOpState.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int failOp() {
        return VkStencilOpState.nfailOp(this.address());
    }

    public int passOp() {
        return VkStencilOpState.npassOp(this.address());
    }

    public int depthFailOp() {
        return VkStencilOpState.ndepthFailOp(this.address());
    }

    public int compareOp() {
        return VkStencilOpState.ncompareOp(this.address());
    }

    public int compareMask() {
        return VkStencilOpState.ncompareMask(this.address());
    }

    public int writeMask() {
        return VkStencilOpState.nwriteMask(this.address());
    }

    public int reference() {
        return VkStencilOpState.nreference(this.address());
    }

    public VkStencilOpState failOp(int value) {
        VkStencilOpState.nfailOp(this.address(), value);
        return this;
    }

    public VkStencilOpState passOp(int value) {
        VkStencilOpState.npassOp(this.address(), value);
        return this;
    }

    public VkStencilOpState depthFailOp(int value) {
        VkStencilOpState.ndepthFailOp(this.address(), value);
        return this;
    }

    public VkStencilOpState compareOp(int value) {
        VkStencilOpState.ncompareOp(this.address(), value);
        return this;
    }

    public VkStencilOpState compareMask(int value) {
        VkStencilOpState.ncompareMask(this.address(), value);
        return this;
    }

    public VkStencilOpState writeMask(int value) {
        VkStencilOpState.nwriteMask(this.address(), value);
        return this;
    }

    public VkStencilOpState reference(int value) {
        VkStencilOpState.nreference(this.address(), value);
        return this;
    }

    public VkStencilOpState set(int failOp, int passOp, int depthFailOp, int compareOp, int compareMask, int writeMask, int reference) {
        this.failOp(failOp);
        this.passOp(passOp);
        this.depthFailOp(depthFailOp);
        this.compareOp(compareOp);
        this.compareMask(compareMask);
        this.writeMask(writeMask);
        this.reference(reference);
        return this;
    }

    public VkStencilOpState set(VkStencilOpState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkStencilOpState malloc() {
        return VkStencilOpState.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkStencilOpState calloc() {
        return VkStencilOpState.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkStencilOpState create() {
        return new VkStencilOpState(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkStencilOpState create(long address) {
        return address == 0L ? null : new VkStencilOpState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkStencilOpState.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkStencilOpState.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkStencilOpState mallocStack() {
        return VkStencilOpState.mallocStack(MemoryStack.stackGet());
    }

    public static VkStencilOpState callocStack() {
        return VkStencilOpState.callocStack(MemoryStack.stackGet());
    }

    public static VkStencilOpState mallocStack(MemoryStack stack) {
        return VkStencilOpState.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkStencilOpState callocStack(MemoryStack stack) {
        return VkStencilOpState.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkStencilOpState.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkStencilOpState.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkStencilOpState.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkStencilOpState.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nfailOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FAILOP);
    }

    public static int npassOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PASSOP);
    }

    public static int ndepthFailOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTHFAILOP);
    }

    public static int ncompareOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPAREOP);
    }

    public static int ncompareMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPAREMASK);
    }

    public static int nwriteMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WRITEMASK);
    }

    public static int nreference(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REFERENCE);
    }

    public static void nfailOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FAILOP, value);
    }

    public static void npassOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PASSOP, value);
    }

    public static void ndepthFailOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTHFAILOP, value);
    }

    public static void ncompareOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMPAREOP, value);
    }

    public static void ncompareMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMPAREMASK, value);
    }

    public static void nwriteMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WRITEMASK, value);
    }

    public static void nreference(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REFERENCE, value);
    }

    static {
        Struct.Layout layout = VkStencilOpState.__struct(VkStencilOpState.__member(4), VkStencilOpState.__member(4), VkStencilOpState.__member(4), VkStencilOpState.__member(4), VkStencilOpState.__member(4), VkStencilOpState.__member(4), VkStencilOpState.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FAILOP = layout.offsetof(0);
        PASSOP = layout.offsetof(1);
        DEPTHFAILOP = layout.offsetof(2);
        COMPAREOP = layout.offsetof(3);
        COMPAREMASK = layout.offsetof(4);
        WRITEMASK = layout.offsetof(5);
        REFERENCE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkStencilOpState, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkStencilOpState newInstance(long address) {
            return new VkStencilOpState(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int failOp() {
            return VkStencilOpState.nfailOp(this.address());
        }

        public int passOp() {
            return VkStencilOpState.npassOp(this.address());
        }

        public int depthFailOp() {
            return VkStencilOpState.ndepthFailOp(this.address());
        }

        public int compareOp() {
            return VkStencilOpState.ncompareOp(this.address());
        }

        public int compareMask() {
            return VkStencilOpState.ncompareMask(this.address());
        }

        public int writeMask() {
            return VkStencilOpState.nwriteMask(this.address());
        }

        public int reference() {
            return VkStencilOpState.nreference(this.address());
        }

        public Buffer failOp(int value) {
            VkStencilOpState.nfailOp(this.address(), value);
            return this;
        }

        public Buffer passOp(int value) {
            VkStencilOpState.npassOp(this.address(), value);
            return this;
        }

        public Buffer depthFailOp(int value) {
            VkStencilOpState.ndepthFailOp(this.address(), value);
            return this;
        }

        public Buffer compareOp(int value) {
            VkStencilOpState.ncompareOp(this.address(), value);
            return this;
        }

        public Buffer compareMask(int value) {
            VkStencilOpState.ncompareMask(this.address(), value);
            return this;
        }

        public Buffer writeMask(int value) {
            VkStencilOpState.nwriteMask(this.address(), value);
            return this;
        }

        public Buffer reference(int value) {
            VkStencilOpState.nreference(this.address(), value);
            return this;
        }
    }
}

