/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubmitInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int WAITSEMAPHORECOUNT;
    public static final int PWAITSEMAPHORES;
    public static final int PWAITDSTSTAGEMASK;
    public static final int COMMANDBUFFERCOUNT;
    public static final int PCOMMANDBUFFERS;
    public static final int SIGNALSEMAPHORECOUNT;
    public static final int PSIGNALSEMAPHORES;

    VkSubmitInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSubmitInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSubmitInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkSubmitInfo.nsType(this.address());
    }

    public long pNext() {
        return VkSubmitInfo.npNext(this.address());
    }

    public int waitSemaphoreCount() {
        return VkSubmitInfo.nwaitSemaphoreCount(this.address());
    }

    public LongBuffer pWaitSemaphores() {
        return VkSubmitInfo.npWaitSemaphores(this.address());
    }

    public IntBuffer pWaitDstStageMask() {
        return VkSubmitInfo.npWaitDstStageMask(this.address());
    }

    public int commandBufferCount() {
        return VkSubmitInfo.ncommandBufferCount(this.address());
    }

    public PointerBuffer pCommandBuffers() {
        return VkSubmitInfo.npCommandBuffers(this.address());
    }

    public int signalSemaphoreCount() {
        return VkSubmitInfo.nsignalSemaphoreCount(this.address());
    }

    public LongBuffer pSignalSemaphores() {
        return VkSubmitInfo.npSignalSemaphores(this.address());
    }

    public VkSubmitInfo sType(int value) {
        VkSubmitInfo.nsType(this.address(), value);
        return this;
    }

    public VkSubmitInfo pNext(long value) {
        VkSubmitInfo.npNext(this.address(), value);
        return this;
    }

    public VkSubmitInfo waitSemaphoreCount(int value) {
        VkSubmitInfo.nwaitSemaphoreCount(this.address(), value);
        return this;
    }

    public VkSubmitInfo pWaitSemaphores(LongBuffer value) {
        VkSubmitInfo.npWaitSemaphores(this.address(), value);
        return this;
    }

    public VkSubmitInfo pWaitDstStageMask(IntBuffer value) {
        VkSubmitInfo.npWaitDstStageMask(this.address(), value);
        return this;
    }

    public VkSubmitInfo pCommandBuffers(PointerBuffer value) {
        VkSubmitInfo.npCommandBuffers(this.address(), value);
        return this;
    }

    public VkSubmitInfo pSignalSemaphores(LongBuffer value) {
        VkSubmitInfo.npSignalSemaphores(this.address(), value);
        return this;
    }

    public VkSubmitInfo set(int sType, long pNext, int waitSemaphoreCount, LongBuffer pWaitSemaphores, IntBuffer pWaitDstStageMask, PointerBuffer pCommandBuffers, LongBuffer pSignalSemaphores) {
        this.sType(sType);
        this.pNext(pNext);
        this.waitSemaphoreCount(waitSemaphoreCount);
        this.pWaitSemaphores(pWaitSemaphores);
        this.pWaitDstStageMask(pWaitDstStageMask);
        this.pCommandBuffers(pCommandBuffers);
        this.pSignalSemaphores(pSignalSemaphores);
        return this;
    }

    public VkSubmitInfo set(VkSubmitInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubmitInfo malloc() {
        return VkSubmitInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSubmitInfo calloc() {
        return VkSubmitInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSubmitInfo create() {
        return new VkSubmitInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSubmitInfo create(long address) {
        return address == 0L ? null : new VkSubmitInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSubmitInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubmitInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSubmitInfo mallocStack() {
        return VkSubmitInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubmitInfo callocStack() {
        return VkSubmitInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSubmitInfo mallocStack(MemoryStack stack) {
        return VkSubmitInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubmitInfo callocStack(MemoryStack stack) {
        return VkSubmitInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubmitInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubmitInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubmitInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubmitInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nwaitSemaphoreCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WAITSEMAPHORECOUNT);
    }

    public static LongBuffer npWaitSemaphores(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHORES), VkSubmitInfo.nwaitSemaphoreCount(struct));
    }

    public static IntBuffer npWaitDstStageMask(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PWAITDSTSTAGEMASK), VkSubmitInfo.nwaitSemaphoreCount(struct));
    }

    public static int ncommandBufferCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMMANDBUFFERCOUNT);
    }

    public static PointerBuffer npCommandBuffers(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)PCOMMANDBUFFERS), VkSubmitInfo.ncommandBufferCount(struct));
    }

    public static int nsignalSemaphoreCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIGNALSEMAPHORECOUNT);
    }

    public static LongBuffer npSignalSemaphores(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PSIGNALSEMAPHORES), VkSubmitInfo.nsignalSemaphoreCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nwaitSemaphoreCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WAITSEMAPHORECOUNT, value);
    }

    public static void npWaitSemaphores(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PWAITSEMAPHORES, MemoryUtil.memAddressSafe(value));
    }

    public static void npWaitDstStageMask(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PWAITDSTSTAGEMASK, MemoryUtil.memAddressSafe(value));
    }

    public static void ncommandBufferCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMMANDBUFFERCOUNT, value);
    }

    public static void npCommandBuffers(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOMMANDBUFFERS, MemoryUtil.memAddressSafe(value));
        VkSubmitInfo.ncommandBufferCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsignalSemaphoreCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIGNALSEMAPHORECOUNT, value);
    }

    public static void npSignalSemaphores(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSIGNALSEMAPHORES, MemoryUtil.memAddressSafe(value));
        VkSubmitInfo.nsignalSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkSubmitInfo.nwaitSemaphoreCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHORES));
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PWAITDSTSTAGEMASK));
        }
        if (VkSubmitInfo.ncommandBufferCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCOMMANDBUFFERS));
        }
        if (VkSubmitInfo.nsignalSemaphoreCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PSIGNALSEMAPHORES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSubmitInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkSubmitInfo.__struct(VkSubmitInfo.__member(4), VkSubmitInfo.__member(POINTER_SIZE), VkSubmitInfo.__member(4), VkSubmitInfo.__member(POINTER_SIZE), VkSubmitInfo.__member(POINTER_SIZE), VkSubmitInfo.__member(4), VkSubmitInfo.__member(POINTER_SIZE), VkSubmitInfo.__member(4), VkSubmitInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        WAITSEMAPHORECOUNT = layout.offsetof(2);
        PWAITSEMAPHORES = layout.offsetof(3);
        PWAITDSTSTAGEMASK = layout.offsetof(4);
        COMMANDBUFFERCOUNT = layout.offsetof(5);
        PCOMMANDBUFFERS = layout.offsetof(6);
        SIGNALSEMAPHORECOUNT = layout.offsetof(7);
        PSIGNALSEMAPHORES = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkSubmitInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSubmitInfo newInstance(long address) {
            return new VkSubmitInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkSubmitInfo.nsType(this.address());
        }

        public long pNext() {
            return VkSubmitInfo.npNext(this.address());
        }

        public int waitSemaphoreCount() {
            return VkSubmitInfo.nwaitSemaphoreCount(this.address());
        }

        public LongBuffer pWaitSemaphores() {
            return VkSubmitInfo.npWaitSemaphores(this.address());
        }

        public IntBuffer pWaitDstStageMask() {
            return VkSubmitInfo.npWaitDstStageMask(this.address());
        }

        public int commandBufferCount() {
            return VkSubmitInfo.ncommandBufferCount(this.address());
        }

        public PointerBuffer pCommandBuffers() {
            return VkSubmitInfo.npCommandBuffers(this.address());
        }

        public int signalSemaphoreCount() {
            return VkSubmitInfo.nsignalSemaphoreCount(this.address());
        }

        public LongBuffer pSignalSemaphores() {
            return VkSubmitInfo.npSignalSemaphores(this.address());
        }

        public Buffer sType(int value) {
            VkSubmitInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkSubmitInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer waitSemaphoreCount(int value) {
            VkSubmitInfo.nwaitSemaphoreCount(this.address(), value);
            return this;
        }

        public Buffer pWaitSemaphores(LongBuffer value) {
            VkSubmitInfo.npWaitSemaphores(this.address(), value);
            return this;
        }

        public Buffer pWaitDstStageMask(IntBuffer value) {
            VkSubmitInfo.npWaitDstStageMask(this.address(), value);
            return this;
        }

        public Buffer pCommandBuffers(PointerBuffer value) {
            VkSubmitInfo.npCommandBuffers(this.address(), value);
            return this;
        }

        public Buffer pSignalSemaphores(LongBuffer value) {
            VkSubmitInfo.npSignalSemaphores(this.address(), value);
            return this;
        }
    }
}

