/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkSurfaceCapabilities2EXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MINIMAGECOUNT;
    public static final int MAXIMAGECOUNT;
    public static final int CURRENTEXTENT;
    public static final int MINIMAGEEXTENT;
    public static final int MAXIMAGEEXTENT;
    public static final int MAXIMAGEARRAYLAYERS;
    public static final int SUPPORTEDTRANSFORMS;
    public static final int CURRENTTRANSFORM;
    public static final int SUPPORTEDCOMPOSITEALPHA;
    public static final int SUPPORTEDUSAGEFLAGS;
    public static final int SUPPORTEDSURFACECOUNTERS;

    VkSurfaceCapabilities2EXT(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSurfaceCapabilities2EXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSurfaceCapabilities2EXT.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkSurfaceCapabilities2EXT.nsType(this.address());
    }

    public long pNext() {
        return VkSurfaceCapabilities2EXT.npNext(this.address());
    }

    public int minImageCount() {
        return VkSurfaceCapabilities2EXT.nminImageCount(this.address());
    }

    public int maxImageCount() {
        return VkSurfaceCapabilities2EXT.nmaxImageCount(this.address());
    }

    public VkExtent2D currentExtent() {
        return VkSurfaceCapabilities2EXT.ncurrentExtent(this.address());
    }

    public VkExtent2D minImageExtent() {
        return VkSurfaceCapabilities2EXT.nminImageExtent(this.address());
    }

    public VkExtent2D maxImageExtent() {
        return VkSurfaceCapabilities2EXT.nmaxImageExtent(this.address());
    }

    public int maxImageArrayLayers() {
        return VkSurfaceCapabilities2EXT.nmaxImageArrayLayers(this.address());
    }

    public int supportedTransforms() {
        return VkSurfaceCapabilities2EXT.nsupportedTransforms(this.address());
    }

    public int currentTransform() {
        return VkSurfaceCapabilities2EXT.ncurrentTransform(this.address());
    }

    public int supportedCompositeAlpha() {
        return VkSurfaceCapabilities2EXT.nsupportedCompositeAlpha(this.address());
    }

    public int supportedUsageFlags() {
        return VkSurfaceCapabilities2EXT.nsupportedUsageFlags(this.address());
    }

    public int supportedSurfaceCounters() {
        return VkSurfaceCapabilities2EXT.nsupportedSurfaceCounters(this.address());
    }

    public static VkSurfaceCapabilities2EXT malloc() {
        return VkSurfaceCapabilities2EXT.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSurfaceCapabilities2EXT calloc() {
        return VkSurfaceCapabilities2EXT.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSurfaceCapabilities2EXT create() {
        return new VkSurfaceCapabilities2EXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSurfaceCapabilities2EXT create(long address) {
        return address == 0L ? null : new VkSurfaceCapabilities2EXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSurfaceCapabilities2EXT.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSurfaceCapabilities2EXT.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSurfaceCapabilities2EXT mallocStack() {
        return VkSurfaceCapabilities2EXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceCapabilities2EXT callocStack() {
        return VkSurfaceCapabilities2EXT.callocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceCapabilities2EXT mallocStack(MemoryStack stack) {
        return VkSurfaceCapabilities2EXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSurfaceCapabilities2EXT callocStack(MemoryStack stack) {
        return VkSurfaceCapabilities2EXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSurfaceCapabilities2EXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSurfaceCapabilities2EXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilities2EXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilities2EXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nminImageCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINIMAGECOUNT);
    }

    public static int nmaxImageCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMAGECOUNT);
    }

    public static VkExtent2D ncurrentExtent(long struct) {
        return VkExtent2D.create(struct + (long)CURRENTEXTENT);
    }

    public static VkExtent2D nminImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINIMAGEEXTENT);
    }

    public static VkExtent2D nmaxImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXIMAGEEXTENT);
    }

    public static int nmaxImageArrayLayers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMAGEARRAYLAYERS);
    }

    public static int nsupportedTransforms(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDTRANSFORMS);
    }

    public static int ncurrentTransform(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURRENTTRANSFORM);
    }

    public static int nsupportedCompositeAlpha(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDCOMPOSITEALPHA);
    }

    public static int nsupportedUsageFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDUSAGEFLAGS);
    }

    public static int nsupportedSurfaceCounters(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDSURFACECOUNTERS);
    }

    static {
        Struct.Layout layout = VkSurfaceCapabilities2EXT.__struct(VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(POINTER_SIZE), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilities2EXT.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilities2EXT.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MINIMAGECOUNT = layout.offsetof(2);
        MAXIMAGECOUNT = layout.offsetof(3);
        CURRENTEXTENT = layout.offsetof(4);
        MINIMAGEEXTENT = layout.offsetof(5);
        MAXIMAGEEXTENT = layout.offsetof(6);
        MAXIMAGEARRAYLAYERS = layout.offsetof(7);
        SUPPORTEDTRANSFORMS = layout.offsetof(8);
        CURRENTTRANSFORM = layout.offsetof(9);
        SUPPORTEDCOMPOSITEALPHA = layout.offsetof(10);
        SUPPORTEDUSAGEFLAGS = layout.offsetof(11);
        SUPPORTEDSURFACECOUNTERS = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<VkSurfaceCapabilities2EXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSurfaceCapabilities2EXT newInstance(long address) {
            return new VkSurfaceCapabilities2EXT(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkSurfaceCapabilities2EXT.nsType(this.address());
        }

        public long pNext() {
            return VkSurfaceCapabilities2EXT.npNext(this.address());
        }

        public int minImageCount() {
            return VkSurfaceCapabilities2EXT.nminImageCount(this.address());
        }

        public int maxImageCount() {
            return VkSurfaceCapabilities2EXT.nmaxImageCount(this.address());
        }

        public VkExtent2D currentExtent() {
            return VkSurfaceCapabilities2EXT.ncurrentExtent(this.address());
        }

        public VkExtent2D minImageExtent() {
            return VkSurfaceCapabilities2EXT.nminImageExtent(this.address());
        }

        public VkExtent2D maxImageExtent() {
            return VkSurfaceCapabilities2EXT.nmaxImageExtent(this.address());
        }

        public int maxImageArrayLayers() {
            return VkSurfaceCapabilities2EXT.nmaxImageArrayLayers(this.address());
        }

        public int supportedTransforms() {
            return VkSurfaceCapabilities2EXT.nsupportedTransforms(this.address());
        }

        public int currentTransform() {
            return VkSurfaceCapabilities2EXT.ncurrentTransform(this.address());
        }

        public int supportedCompositeAlpha() {
            return VkSurfaceCapabilities2EXT.nsupportedCompositeAlpha(this.address());
        }

        public int supportedUsageFlags() {
            return VkSurfaceCapabilities2EXT.nsupportedUsageFlags(this.address());
        }

        public int supportedSurfaceCounters() {
            return VkSurfaceCapabilities2EXT.nsupportedSurfaceCounters(this.address());
        }
    }
}

