/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSurfaceCapabilitiesKHR;

public class VkSurfaceCapabilities2KHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SURFACECAPABILITIES;

    VkSurfaceCapabilities2KHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSurfaceCapabilities2KHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSurfaceCapabilities2KHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkSurfaceCapabilities2KHR.nsType(this.address());
    }

    public long pNext() {
        return VkSurfaceCapabilities2KHR.npNext(this.address());
    }

    public VkSurfaceCapabilitiesKHR surfaceCapabilities() {
        return VkSurfaceCapabilities2KHR.nsurfaceCapabilities(this.address());
    }

    public static VkSurfaceCapabilities2KHR malloc() {
        return VkSurfaceCapabilities2KHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSurfaceCapabilities2KHR calloc() {
        return VkSurfaceCapabilities2KHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSurfaceCapabilities2KHR create() {
        return new VkSurfaceCapabilities2KHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSurfaceCapabilities2KHR create(long address) {
        return address == 0L ? null : new VkSurfaceCapabilities2KHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSurfaceCapabilities2KHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSurfaceCapabilities2KHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSurfaceCapabilities2KHR mallocStack() {
        return VkSurfaceCapabilities2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceCapabilities2KHR callocStack() {
        return VkSurfaceCapabilities2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceCapabilities2KHR mallocStack(MemoryStack stack) {
        return VkSurfaceCapabilities2KHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSurfaceCapabilities2KHR callocStack(MemoryStack stack) {
        return VkSurfaceCapabilities2KHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSurfaceCapabilities2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSurfaceCapabilities2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilities2KHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilities2KHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkSurfaceCapabilitiesKHR nsurfaceCapabilities(long struct) {
        return VkSurfaceCapabilitiesKHR.create(struct + (long)SURFACECAPABILITIES);
    }

    static {
        Struct.Layout layout = VkSurfaceCapabilities2KHR.__struct(VkSurfaceCapabilities2KHR.__member(4), VkSurfaceCapabilities2KHR.__member(POINTER_SIZE), VkSurfaceCapabilities2KHR.__member(VkSurfaceCapabilitiesKHR.SIZEOF, VkSurfaceCapabilitiesKHR.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SURFACECAPABILITIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSurfaceCapabilities2KHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSurfaceCapabilities2KHR newInstance(long address) {
            return new VkSurfaceCapabilities2KHR(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkSurfaceCapabilities2KHR.nsType(this.address());
        }

        public long pNext() {
            return VkSurfaceCapabilities2KHR.npNext(this.address());
        }

        public VkSurfaceCapabilitiesKHR surfaceCapabilities() {
            return VkSurfaceCapabilities2KHR.nsurfaceCapabilities(this.address());
        }
    }
}

