/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSurfaceFormatKHR;

public class VkSurfaceFormat2KHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SURFACEFORMAT;

    VkSurfaceFormat2KHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSurfaceFormat2KHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSurfaceFormat2KHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkSurfaceFormat2KHR.nsType(this.address());
    }

    public long pNext() {
        return VkSurfaceFormat2KHR.npNext(this.address());
    }

    public VkSurfaceFormatKHR surfaceFormat() {
        return VkSurfaceFormat2KHR.nsurfaceFormat(this.address());
    }

    public static VkSurfaceFormat2KHR malloc() {
        return VkSurfaceFormat2KHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSurfaceFormat2KHR calloc() {
        return VkSurfaceFormat2KHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSurfaceFormat2KHR create() {
        return new VkSurfaceFormat2KHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSurfaceFormat2KHR create(long address) {
        return address == 0L ? null : new VkSurfaceFormat2KHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSurfaceFormat2KHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSurfaceFormat2KHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSurfaceFormat2KHR mallocStack() {
        return VkSurfaceFormat2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceFormat2KHR callocStack() {
        return VkSurfaceFormat2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceFormat2KHR mallocStack(MemoryStack stack) {
        return VkSurfaceFormat2KHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSurfaceFormat2KHR callocStack(MemoryStack stack) {
        return VkSurfaceFormat2KHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSurfaceFormat2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSurfaceFormat2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSurfaceFormat2KHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSurfaceFormat2KHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkSurfaceFormatKHR nsurfaceFormat(long struct) {
        return VkSurfaceFormatKHR.create(struct + (long)SURFACEFORMAT);
    }

    static {
        Struct.Layout layout = VkSurfaceFormat2KHR.__struct(VkSurfaceFormat2KHR.__member(4), VkSurfaceFormat2KHR.__member(POINTER_SIZE), VkSurfaceFormat2KHR.__member(VkSurfaceFormatKHR.SIZEOF, VkSurfaceFormatKHR.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SURFACEFORMAT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSurfaceFormat2KHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSurfaceFormat2KHR newInstance(long address) {
            return new VkSurfaceFormat2KHR(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkSurfaceFormat2KHR.nsType(this.address());
        }

        public long pNext() {
            return VkSurfaceFormat2KHR.npNext(this.address());
        }

        public VkSurfaceFormatKHR surfaceFormat() {
            return VkSurfaceFormat2KHR.nsurfaceFormat(this.address());
        }
    }
}

