/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSurfaceFormatKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int COLORSPACE;

    VkSurfaceFormatKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSurfaceFormatKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSurfaceFormatKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int format() {
        return VkSurfaceFormatKHR.nformat(this.address());
    }

    public int colorSpace() {
        return VkSurfaceFormatKHR.ncolorSpace(this.address());
    }

    public static VkSurfaceFormatKHR malloc() {
        return VkSurfaceFormatKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSurfaceFormatKHR calloc() {
        return VkSurfaceFormatKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSurfaceFormatKHR create() {
        return new VkSurfaceFormatKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSurfaceFormatKHR create(long address) {
        return address == 0L ? null : new VkSurfaceFormatKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSurfaceFormatKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSurfaceFormatKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSurfaceFormatKHR mallocStack() {
        return VkSurfaceFormatKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceFormatKHR callocStack() {
        return VkSurfaceFormatKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceFormatKHR mallocStack(MemoryStack stack) {
        return VkSurfaceFormatKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSurfaceFormatKHR callocStack(MemoryStack stack) {
        return VkSurfaceFormatKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSurfaceFormatKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSurfaceFormatKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSurfaceFormatKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSurfaceFormatKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int ncolorSpace(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORSPACE);
    }

    static {
        Struct.Layout layout = VkSurfaceFormatKHR.__struct(VkSurfaceFormatKHR.__member(4), VkSurfaceFormatKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        COLORSPACE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkSurfaceFormatKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSurfaceFormatKHR newInstance(long address) {
            return new VkSurfaceFormatKHR(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int format() {
            return VkSurfaceFormatKHR.nformat(this.address());
        }

        public int colorSpace() {
            return VkSurfaceFormatKHR.ncolorSpace(this.address());
        }
    }
}

