/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkValidationFlagsEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DISABLEDVALIDATIONCHECKCOUNT;
    public static final int PDISABLEDVALIDATIONCHECKS;

    VkValidationFlagsEXT(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkValidationFlagsEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkValidationFlagsEXT.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkValidationFlagsEXT.nsType(this.address());
    }

    public long pNext() {
        return VkValidationFlagsEXT.npNext(this.address());
    }

    public int disabledValidationCheckCount() {
        return VkValidationFlagsEXT.ndisabledValidationCheckCount(this.address());
    }

    public IntBuffer pDisabledValidationChecks() {
        return VkValidationFlagsEXT.npDisabledValidationChecks(this.address());
    }

    public VkValidationFlagsEXT sType(int value) {
        VkValidationFlagsEXT.nsType(this.address(), value);
        return this;
    }

    public VkValidationFlagsEXT pNext(long value) {
        VkValidationFlagsEXT.npNext(this.address(), value);
        return this;
    }

    public VkValidationFlagsEXT pDisabledValidationChecks(IntBuffer value) {
        VkValidationFlagsEXT.npDisabledValidationChecks(this.address(), value);
        return this;
    }

    public VkValidationFlagsEXT set(int sType, long pNext, IntBuffer pDisabledValidationChecks) {
        this.sType(sType);
        this.pNext(pNext);
        this.pDisabledValidationChecks(pDisabledValidationChecks);
        return this;
    }

    public VkValidationFlagsEXT set(VkValidationFlagsEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkValidationFlagsEXT malloc() {
        return VkValidationFlagsEXT.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkValidationFlagsEXT calloc() {
        return VkValidationFlagsEXT.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkValidationFlagsEXT create() {
        return new VkValidationFlagsEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkValidationFlagsEXT create(long address) {
        return address == 0L ? null : new VkValidationFlagsEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkValidationFlagsEXT.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkValidationFlagsEXT.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkValidationFlagsEXT mallocStack() {
        return VkValidationFlagsEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkValidationFlagsEXT callocStack() {
        return VkValidationFlagsEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkValidationFlagsEXT mallocStack(MemoryStack stack) {
        return VkValidationFlagsEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkValidationFlagsEXT callocStack(MemoryStack stack) {
        return VkValidationFlagsEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkValidationFlagsEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkValidationFlagsEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkValidationFlagsEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkValidationFlagsEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndisabledValidationCheckCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DISABLEDVALIDATIONCHECKCOUNT);
    }

    public static IntBuffer npDisabledValidationChecks(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PDISABLEDVALIDATIONCHECKS), VkValidationFlagsEXT.ndisabledValidationCheckCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndisabledValidationCheckCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DISABLEDVALIDATIONCHECKCOUNT, value);
    }

    public static void npDisabledValidationChecks(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDISABLEDVALIDATIONCHECKS, MemoryUtil.memAddress(value));
        VkValidationFlagsEXT.ndisabledValidationCheckCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PDISABLEDVALIDATIONCHECKS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkValidationFlagsEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkValidationFlagsEXT.__struct(VkValidationFlagsEXT.__member(4), VkValidationFlagsEXT.__member(POINTER_SIZE), VkValidationFlagsEXT.__member(4), VkValidationFlagsEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DISABLEDVALIDATIONCHECKCOUNT = layout.offsetof(2);
        PDISABLEDVALIDATIONCHECKS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkValidationFlagsEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkValidationFlagsEXT newInstance(long address) {
            return new VkValidationFlagsEXT(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkValidationFlagsEXT.nsType(this.address());
        }

        public long pNext() {
            return VkValidationFlagsEXT.npNext(this.address());
        }

        public int disabledValidationCheckCount() {
            return VkValidationFlagsEXT.ndisabledValidationCheckCount(this.address());
        }

        public IntBuffer pDisabledValidationChecks() {
            return VkValidationFlagsEXT.npDisabledValidationChecks(this.address());
        }

        public Buffer sType(int value) {
            VkValidationFlagsEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkValidationFlagsEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pDisabledValidationChecks(IntBuffer value) {
            VkValidationFlagsEXT.npDisabledValidationChecks(this.address(), value);
            return this;
        }
    }
}

