/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkWin32KeyedMutexAcquireReleaseInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ACQUIRECOUNT;
    public static final int PACQUIRESYNCS;
    public static final int PACQUIREKEYS;
    public static final int PACQUIRETIMEOUTMILLISECONDS;
    public static final int RELEASECOUNT;
    public static final int PRELEASESYNCS;
    public static final int PRELEASEKEYS;

    VkWin32KeyedMutexAcquireReleaseInfoNV(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkWin32KeyedMutexAcquireReleaseInfoNV.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.nsType(this.address());
    }

    public long pNext() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.npNext(this.address());
    }

    public int acquireCount() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.nacquireCount(this.address());
    }

    public LongBuffer pAcquireSyncs() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireSyncs(this.address());
    }

    public LongBuffer pAcquireKeys() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireKeys(this.address());
    }

    public IntBuffer pAcquireTimeoutMilliseconds() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireTimeoutMilliseconds(this.address());
    }

    public int releaseCount() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.nreleaseCount(this.address());
    }

    public LongBuffer pReleaseSyncs() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.npReleaseSyncs(this.address());
    }

    public LongBuffer pReleaseKeys() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.npReleaseKeys(this.address());
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV sType(int value) {
        VkWin32KeyedMutexAcquireReleaseInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV pNext(long value) {
        VkWin32KeyedMutexAcquireReleaseInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV acquireCount(int value) {
        VkWin32KeyedMutexAcquireReleaseInfoNV.nacquireCount(this.address(), value);
        return this;
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV pAcquireSyncs(LongBuffer value) {
        VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireSyncs(this.address(), value);
        return this;
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV pAcquireKeys(LongBuffer value) {
        VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireKeys(this.address(), value);
        return this;
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV pAcquireTimeoutMilliseconds(IntBuffer value) {
        VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireTimeoutMilliseconds(this.address(), value);
        return this;
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV releaseCount(int value) {
        VkWin32KeyedMutexAcquireReleaseInfoNV.nreleaseCount(this.address(), value);
        return this;
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV pReleaseSyncs(LongBuffer value) {
        VkWin32KeyedMutexAcquireReleaseInfoNV.npReleaseSyncs(this.address(), value);
        return this;
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV pReleaseKeys(LongBuffer value) {
        VkWin32KeyedMutexAcquireReleaseInfoNV.npReleaseKeys(this.address(), value);
        return this;
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV set(int sType, long pNext, int acquireCount, LongBuffer pAcquireSyncs, LongBuffer pAcquireKeys, IntBuffer pAcquireTimeoutMilliseconds, int releaseCount, LongBuffer pReleaseSyncs, LongBuffer pReleaseKeys) {
        this.sType(sType);
        this.pNext(pNext);
        this.acquireCount(acquireCount);
        this.pAcquireSyncs(pAcquireSyncs);
        this.pAcquireKeys(pAcquireKeys);
        this.pAcquireTimeoutMilliseconds(pAcquireTimeoutMilliseconds);
        this.releaseCount(releaseCount);
        this.pReleaseSyncs(pReleaseSyncs);
        this.pReleaseKeys(pReleaseKeys);
        return this;
    }

    public VkWin32KeyedMutexAcquireReleaseInfoNV set(VkWin32KeyedMutexAcquireReleaseInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkWin32KeyedMutexAcquireReleaseInfoNV malloc() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkWin32KeyedMutexAcquireReleaseInfoNV calloc() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkWin32KeyedMutexAcquireReleaseInfoNV create() {
        return new VkWin32KeyedMutexAcquireReleaseInfoNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkWin32KeyedMutexAcquireReleaseInfoNV create(long address) {
        return address == 0L ? null : new VkWin32KeyedMutexAcquireReleaseInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkWin32KeyedMutexAcquireReleaseInfoNV mallocStack() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkWin32KeyedMutexAcquireReleaseInfoNV callocStack() {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.callocStack(MemoryStack.stackGet());
    }

    public static VkWin32KeyedMutexAcquireReleaseInfoNV mallocStack(MemoryStack stack) {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkWin32KeyedMutexAcquireReleaseInfoNV callocStack(MemoryStack stack) {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkWin32KeyedMutexAcquireReleaseInfoNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nacquireCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ACQUIRECOUNT);
    }

    public static LongBuffer npAcquireSyncs(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PACQUIRESYNCS), VkWin32KeyedMutexAcquireReleaseInfoNV.nacquireCount(struct));
    }

    public static LongBuffer npAcquireKeys(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PACQUIREKEYS), VkWin32KeyedMutexAcquireReleaseInfoNV.nacquireCount(struct));
    }

    public static IntBuffer npAcquireTimeoutMilliseconds(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PACQUIRETIMEOUTMILLISECONDS), VkWin32KeyedMutexAcquireReleaseInfoNV.nacquireCount(struct));
    }

    public static int nreleaseCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RELEASECOUNT);
    }

    public static LongBuffer npReleaseSyncs(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PRELEASESYNCS), VkWin32KeyedMutexAcquireReleaseInfoNV.nreleaseCount(struct));
    }

    public static LongBuffer npReleaseKeys(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PRELEASEKEYS), VkWin32KeyedMutexAcquireReleaseInfoNV.nreleaseCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nacquireCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ACQUIRECOUNT, value);
    }

    public static void npAcquireSyncs(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PACQUIRESYNCS, MemoryUtil.memAddressSafe(value));
    }

    public static void npAcquireKeys(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PACQUIREKEYS, MemoryUtil.memAddressSafe(value));
    }

    public static void npAcquireTimeoutMilliseconds(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PACQUIRETIMEOUTMILLISECONDS, MemoryUtil.memAddressSafe(value));
    }

    public static void nreleaseCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RELEASECOUNT, value);
    }

    public static void npReleaseSyncs(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PRELEASESYNCS, MemoryUtil.memAddressSafe(value));
    }

    public static void npReleaseKeys(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PRELEASEKEYS, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        if (VkWin32KeyedMutexAcquireReleaseInfoNV.nacquireCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PACQUIRESYNCS));
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PACQUIREKEYS));
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PACQUIRETIMEOUTMILLISECONDS));
        }
        if (VkWin32KeyedMutexAcquireReleaseInfoNV.nreleaseCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PRELEASESYNCS));
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PRELEASEKEYS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkWin32KeyedMutexAcquireReleaseInfoNV.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkWin32KeyedMutexAcquireReleaseInfoNV.__struct(VkWin32KeyedMutexAcquireReleaseInfoNV.__member(4), VkWin32KeyedMutexAcquireReleaseInfoNV.__member(POINTER_SIZE), VkWin32KeyedMutexAcquireReleaseInfoNV.__member(4), VkWin32KeyedMutexAcquireReleaseInfoNV.__member(POINTER_SIZE), VkWin32KeyedMutexAcquireReleaseInfoNV.__member(POINTER_SIZE), VkWin32KeyedMutexAcquireReleaseInfoNV.__member(POINTER_SIZE), VkWin32KeyedMutexAcquireReleaseInfoNV.__member(4), VkWin32KeyedMutexAcquireReleaseInfoNV.__member(POINTER_SIZE), VkWin32KeyedMutexAcquireReleaseInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ACQUIRECOUNT = layout.offsetof(2);
        PACQUIRESYNCS = layout.offsetof(3);
        PACQUIREKEYS = layout.offsetof(4);
        PACQUIRETIMEOUTMILLISECONDS = layout.offsetof(5);
        RELEASECOUNT = layout.offsetof(6);
        PRELEASESYNCS = layout.offsetof(7);
        PRELEASEKEYS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkWin32KeyedMutexAcquireReleaseInfoNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkWin32KeyedMutexAcquireReleaseInfoNV newInstance(long address) {
            return new VkWin32KeyedMutexAcquireReleaseInfoNV(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkWin32KeyedMutexAcquireReleaseInfoNV.nsType(this.address());
        }

        public long pNext() {
            return VkWin32KeyedMutexAcquireReleaseInfoNV.npNext(this.address());
        }

        public int acquireCount() {
            return VkWin32KeyedMutexAcquireReleaseInfoNV.nacquireCount(this.address());
        }

        public LongBuffer pAcquireSyncs() {
            return VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireSyncs(this.address());
        }

        public LongBuffer pAcquireKeys() {
            return VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireKeys(this.address());
        }

        public IntBuffer pAcquireTimeoutMilliseconds() {
            return VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireTimeoutMilliseconds(this.address());
        }

        public int releaseCount() {
            return VkWin32KeyedMutexAcquireReleaseInfoNV.nreleaseCount(this.address());
        }

        public LongBuffer pReleaseSyncs() {
            return VkWin32KeyedMutexAcquireReleaseInfoNV.npReleaseSyncs(this.address());
        }

        public LongBuffer pReleaseKeys() {
            return VkWin32KeyedMutexAcquireReleaseInfoNV.npReleaseKeys(this.address());
        }

        public Buffer sType(int value) {
            VkWin32KeyedMutexAcquireReleaseInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkWin32KeyedMutexAcquireReleaseInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer acquireCount(int value) {
            VkWin32KeyedMutexAcquireReleaseInfoNV.nacquireCount(this.address(), value);
            return this;
        }

        public Buffer pAcquireSyncs(LongBuffer value) {
            VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireSyncs(this.address(), value);
            return this;
        }

        public Buffer pAcquireKeys(LongBuffer value) {
            VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireKeys(this.address(), value);
            return this;
        }

        public Buffer pAcquireTimeoutMilliseconds(IntBuffer value) {
            VkWin32KeyedMutexAcquireReleaseInfoNV.npAcquireTimeoutMilliseconds(this.address(), value);
            return this;
        }

        public Buffer releaseCount(int value) {
            VkWin32KeyedMutexAcquireReleaseInfoNV.nreleaseCount(this.address(), value);
            return this;
        }

        public Buffer pReleaseSyncs(LongBuffer value) {
            VkWin32KeyedMutexAcquireReleaseInfoNV.npReleaseSyncs(this.address(), value);
            return this;
        }

        public Buffer pReleaseKeys(LongBuffer value) {
            VkWin32KeyedMutexAcquireReleaseInfoNV.npReleaseKeys(this.address(), value);
            return this;
        }
    }
}

