/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkWin32SurfaceCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int HINSTANCE;
    public static final int HWND;

    VkWin32SurfaceCreateInfoKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkWin32SurfaceCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkWin32SurfaceCreateInfoKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkWin32SurfaceCreateInfoKHR.nsType(this.address());
    }

    public long pNext() {
        return VkWin32SurfaceCreateInfoKHR.npNext(this.address());
    }

    public int flags() {
        return VkWin32SurfaceCreateInfoKHR.nflags(this.address());
    }

    public long hinstance() {
        return VkWin32SurfaceCreateInfoKHR.nhinstance(this.address());
    }

    public long hwnd() {
        return VkWin32SurfaceCreateInfoKHR.nhwnd(this.address());
    }

    public VkWin32SurfaceCreateInfoKHR sType(int value) {
        VkWin32SurfaceCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR pNext(long value) {
        VkWin32SurfaceCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR flags(int value) {
        VkWin32SurfaceCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR hinstance(long value) {
        VkWin32SurfaceCreateInfoKHR.nhinstance(this.address(), value);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR hwnd(long value) {
        VkWin32SurfaceCreateInfoKHR.nhwnd(this.address(), value);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR set(int sType, long pNext, int flags, long hinstance, long hwnd) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.hinstance(hinstance);
        this.hwnd(hwnd);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR set(VkWin32SurfaceCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkWin32SurfaceCreateInfoKHR malloc() {
        return VkWin32SurfaceCreateInfoKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkWin32SurfaceCreateInfoKHR calloc() {
        return VkWin32SurfaceCreateInfoKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkWin32SurfaceCreateInfoKHR create() {
        return new VkWin32SurfaceCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkWin32SurfaceCreateInfoKHR create(long address) {
        return address == 0L ? null : new VkWin32SurfaceCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkWin32SurfaceCreateInfoKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkWin32SurfaceCreateInfoKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkWin32SurfaceCreateInfoKHR mallocStack() {
        return VkWin32SurfaceCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkWin32SurfaceCreateInfoKHR callocStack() {
        return VkWin32SurfaceCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkWin32SurfaceCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkWin32SurfaceCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkWin32SurfaceCreateInfoKHR callocStack(MemoryStack stack) {
        return VkWin32SurfaceCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkWin32SurfaceCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkWin32SurfaceCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkWin32SurfaceCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkWin32SurfaceCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nhinstance(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HINSTANCE);
    }

    public static long nhwnd(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HWND);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nhinstance(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HINSTANCE, Checks.check(value));
    }

    public static void nhwnd(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HWND, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HINSTANCE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HWND));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkWin32SurfaceCreateInfoKHR.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkWin32SurfaceCreateInfoKHR.__struct(VkWin32SurfaceCreateInfoKHR.__member(4), VkWin32SurfaceCreateInfoKHR.__member(POINTER_SIZE), VkWin32SurfaceCreateInfoKHR.__member(4), VkWin32SurfaceCreateInfoKHR.__member(POINTER_SIZE), VkWin32SurfaceCreateInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        HINSTANCE = layout.offsetof(3);
        HWND = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkWin32SurfaceCreateInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkWin32SurfaceCreateInfoKHR newInstance(long address) {
            return new VkWin32SurfaceCreateInfoKHR(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkWin32SurfaceCreateInfoKHR.nsType(this.address());
        }

        public long pNext() {
            return VkWin32SurfaceCreateInfoKHR.npNext(this.address());
        }

        public int flags() {
            return VkWin32SurfaceCreateInfoKHR.nflags(this.address());
        }

        public long hinstance() {
            return VkWin32SurfaceCreateInfoKHR.nhinstance(this.address());
        }

        public long hwnd() {
            return VkWin32SurfaceCreateInfoKHR.nhwnd(this.address());
        }

        public Buffer sType(int value) {
            VkWin32SurfaceCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkWin32SurfaceCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkWin32SurfaceCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer hinstance(long value) {
            VkWin32SurfaceCreateInfoKHR.nhinstance(this.address(), value);
            return this;
        }

        public Buffer hwnd(long value) {
            VkWin32SurfaceCreateInfoKHR.nhwnd(this.address(), value);
            return this;
        }
    }
}

