#version 430 core

uniform samplerCube cube_texture;
uniform int black_is_opaque = 1;
uniform vec3 tint = vec3(0,0,0);
uniform float opaqueness = 1.0;

in vec3 texCoordsVarying;
out vec4 color;

void main() {
  vec4 c = texture(cube_texture, texCoordsVarying);  
  c.a = max(length(c.rgb),black_is_opaque) * opaqueness;
  c.rgb = c.rgb + tint;

  color = c;
}
