#version 430 core

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform samplerCube cube_texture;
layout(binding=2) uniform samplerCube cube_texture2;
layout(binding=3) uniform samplerCube cube_texture3;

uniform mat4 V;
uniform float irriscedence_factor = 1.5;
uniform float reflection_factor = 1.0;
uniform float diffuse_tex_factor = 1.0;
uniform float opaqueness = 1.0;
uniform vec3  ref2_tint = vec3(0,0,0);
uniform float ref2_opaq = 0;
uniform int black_is_opaque = 1;
uniform float ref3_opaq = 0;

in vec2 texCoordsVarying;
in vec4 colorVarying;
in vec3 pos_eye;
in vec3 norm_eye;
out vec4 color;

void main() {
  vec3 incident_eye = normalize(pos_eye);
  vec3 normal = normalize(norm_eye);

  vec3 reflected = reflect(incident_eye, normal);
  // convert from eye to world space
  reflected = vec3(inverse(V) * vec4(reflected, 0.0));
  
  float view_dot_norm = max(dot(normal, incident_eye),0.0);
  float view_dot_norm_inv = 1.0 - view_dot_norm;

  vec4 refColor = texture(cube_texture, reflected) * view_dot_norm;
  refColor.r += irriscedence_factor * texture(cube_texture, reflected + vec3(0.1,0.0,0.0) * view_dot_norm_inv).r * view_dot_norm_inv;
  refColor.g += irriscedence_factor * texture(cube_texture, reflected + vec3(0.0,0.1,0.0) * view_dot_norm_inv).g * view_dot_norm_inv;
  refColor.b += irriscedence_factor * texture(cube_texture, reflected + vec3(0.0,0.0,0.1) * view_dot_norm_inv).b * view_dot_norm_inv;
  refColor.a = 1.0;

  vec4 refColor2 = texture(cube_texture2,reflected);
  refColor2.rgb *= ref2_tint;
  refColor2.rgb *= ref2_opaq;
 
  vec4 refColor3 = texture(cube_texture3,reflected);
  
  vec4 ref = ( refColor) * reflection_factor + (refColor3+refColor2) * ref3_opaq;

  color = texture(tex, texCoordsVarying) * colorVarying * diffuse_tex_factor + ref;  
  color.a = max(length(color.rgb),black_is_opaque) * opaqueness;
}
