#version 430 core

uniform sampler2D tex;

in vec2 textureCoord;
out vec4 color;

float linearizeDepth(in vec2 uv) {
   float zNear = 0.01;
   float zFar  = 100.0;
   float depth = texture(tex, uv).r;
   return (2.0 * zNear) / ((zFar + zNear) - depth *(zFar - zNear));
}

void main() {
   //float a = 1.0 - texture(tex,textureCoord).a;
   //color.rgb = texture(tex,textureCoord).rrr;
   float c = linearizeDepth(textureCoord);
   color.rgb = vec3(c,c,c);
   color.a = 1.0;
}
