#version 430 core

uniform mat4 mvp;
uniform float time;
uniform float width;
uniform float height;

uniform mat4 M;
uniform mat4 P;
uniform mat4 V;
uniform vec2 screenSize = vec2(1280,720);
uniform float spriteSize = 10.0;

layout(location=0) in vec3 position;

out vec2 texCoord;

void main() {
  
  /*vec4 eyePos = M * V * vec4(position,1.0);
  vec4 projVoxel = P * vec4(spriteSize,spriteSize,eyePos.z,eyePos.w);
  vec2 projSize = screenSize * projVoxel.xy / projVoxel.w;

  texCoord.x = (position.x + 1.0) / 2.0;
  texCoord.y = (position.y + 1.0) / 2.0;
  
  gl_PointSize = 10;// * (projSize.x+projSize.y);
  gl_Position = P * eyePos;
*/

   //vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );
   // float cameraDist = distance( mvPosition, origin );
   // gl_PointSize = 200.0 / cameraDist;


  

  //gl_Position = mvp * vec4(position.xyz,1.0);
  vec4 wPos = vec4(position.xyz,1.0);  

  wPos.x = wPos.x + sin(time*3+wPos.x*wPos.y) * 0.1;
  wPos.y = wPos.y + cos(time*2+wPos.x) * sin(time*3) * 0.1;
  wPos.z = wPos.z + sin(time) * cos(time+wPos.x*wPos.y) * 0.2;

  vec4 pos =  V * M * wPos;//mvp * wPos;

  float cameraDist = distance(pos, vec4(0,0,0,0));
  gl_PointSize = max(50.0 / max(cameraDist,1.0),7);

  texCoord.x = (position.x + 1.0) / 2.0;
  texCoord.y = (position.y + 1.0) / 2.0;

  //vec2 pos = position.xy;
   //pos.x = pos.x + sin(time*3+pos.x*pos.y) *0.1;
   //pos.y = pos.y + cos(time*2+pos.x) * sin(time) * 0.1;
   //pos.z = pos.z + sin(time) * cos(time+pos.x*pos.y);
  gl_Position = P * vec4(pos.xy,pos.z,pos.w);

}