#version 430 core

uniform sampler2D tex;
uniform float time;
uniform float width;
uniform float height;
uniform float BarrelPower = 2.0;

const float PI = 3.1415926535;

in vec2 textureCoord;
out vec4 color;

vec2 Distort(vec2 p)
{
    float theta  = atan(p.y, p.x);
    float radius = length(p);
    radius = pow(radius, BarrelPower);
    p.x = radius * cos(theta);
    p.y = radius * sin(theta);
    return 0.5 * (p + 1.0);
}

void main()
{
  vec2 xy = 2.0 * textureCoord.xy - 1.0;
  vec2 uv;
  float d = length(xy);
  if (d < 1.0)
  {
    uv = Distort(xy);
  }
  else
  {
    uv = textureCoord.xy;
  }
  vec4 c = texture(tex, uv);
  color = c;
}