#version 430 core

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D lens;
uniform float time;
uniform float width;
uniform float height;

uniform float LumTresh;
uniform float lensFactor;

in vec2 textureCoord;
out vec4 fragColor;

float luma(vec3 color) {
   return dot(color.rgb, vec3(0.2126, 0.7152, 0.0722));
}

void main() {
    vec2 lensUV = textureCoord;
    lensUV.x +=sin(time)*0.01;
    lensUV.y +=cos(time)*0.01;
    vec4 texCol = texture(tex,textureCoord);
    vec4 lensCol = texture(lens,fract(lensUV));
    //float brightness = luma(texCol.rgb);
    //fragColor = texCol * brightness * brightness;
    float texLuma = clamp(luma(texCol.rgb) - LumTresh, 0.0, 1.0) * (1.0 / (1.0 - LumTresh));
    lensCol = mix(vec4(0),lensCol,texLuma * lensFactor) * lensCol * lensFactor;
    
    fragColor = (lensCol * texLuma + texCol * texLuma);
    fragColor.a = 1;
}
