#version 430 core

uniform sampler2D tex;
uniform float time;
uniform float width;
uniform float height;

uniform float vx_offset = 1.1;

uniform float hatch_y_offset =  5.0;
uniform float lum_threshold_1 = 1.0;
uniform float lum_threshold_2 = 0.7;
uniform float lum_threshold_3 = 0.5;
uniform float lum_threshold_4 = 0.3;

in vec2 textureCoord;
out vec4 color;

void main() 
{ 
  vec2 uv = textureCoord;

  vec3 tc = vec3(1.0, 0.0, 0.0);
  if (uv.x < (vx_offset-0.005))
  {
    float lum = length(texture(tex, uv).rgb);
    tc = vec3(1.0, 1.0, 1.0);
  
    if (lum < lum_threshold_1) 
    {
      if (mod(gl_FragCoord.x + gl_FragCoord.y, 10.0) == 0.0) 
        tc = vec3(0.0, 0.0, 0.0);
    }  
  
    if (lum < lum_threshold_2) 
    {
      if (mod(gl_FragCoord.x - gl_FragCoord.y, 10.0) == 0.0) 
        tc = vec3(0.0, 0.0, 0.0);
    }  
  
    if (lum < lum_threshold_3) 
    {
      if (mod(gl_FragCoord.x + gl_FragCoord.y - hatch_y_offset, 10.0) == 0.0) 
        tc = vec3(0.0, 0.0, 0.0);
    }  
  
    if (lum < lum_threshold_4) 
    {
      if (mod(gl_FragCoord.x - gl_FragCoord.y - hatch_y_offset, 10.0) == 0.0) 
        tc = vec3(0.0, 0.0, 0.0);
    }
  }
  else if (uv.x>=(vx_offset+0.005))
  {
    tc = texture(tex, uv).rgb;
  }
  
  color = vec4(tc, 1.0);
}
