#version 430 core

layout(binding = 0) uniform sampler2D blurred;
layout(binding = 1) uniform sampler2D normal;
layout(binding = 2) uniform sampler2D depth;

in vec2 textureCoord;
out vec4 color;

float linearizeDepth(in vec2 uv) {
   float zNear = 0.01;
   float zFar  = 100.0;
   float depth = texture(depth, uv).r;
   return (2.0 * zNear) / ((zFar + zNear) - depth * (zFar - zNear));
}

void main() {
    float d = linearizeDepth(textureCoord);
    vec3 normCol = texture(normal,textureCoord).rgb;
    vec3 blurCol = texture(blurred,textureCoord).rgb;
    color.rgb = mix(normCol,blurCol,d);
    color.a=1;
}
