#version 430 core

layout(binding=0) uniform sampler2D tex;
uniform float time;
uniform float width;
uniform float height;

const vec2 resolution = textureSize(tex,0);

uniform int NumSamples;// = 12;
uniform vec4 vTint;// = vec4(0.7f,0.4f,0.2f,1.0f);
uniform float fTexScale;// = 2f;
uniform float fBlurScale;// = 0.15f;
/*
uniform int NumSamples = 12;
uniform vec4 vTint = vec4(0.7f, 0.2f, 0.9f, 1.0f);
uniform float fTexScale = 0.5f;
uniform float fBlurScale = 0.1f;
*/
const float fThreshold = 0.1f;

in vec2 textureCoord;
out vec4 fragColor;


void main() {


    // The flare should appear on the opposite side of the screen as the
    // source of the light, so first we mirror the texture coordinate.
    // Then we normalize so we can apply a scaling factor.
    vec2 vMirrorCoord = vec2(1.0f, 1.0f) - textureCoord;
    //vec2 vNormalizedCoord = vMirrorCoord * 2.0f - 1.0f;
    vMirrorCoord *= fTexScale;

    // We'll blur towards the center of screen, and also away from it.
    vec2 vTowardCenter = normalize(-vMirrorCoord);
    vec2 fBlurDist = vec2(fBlurScale * float(NumSamples));
    vec2 vStartPoint = vMirrorCoord + ((vTowardCenter / resolution) * fBlurDist);
    vec2 vStep = -(vTowardCenter / resolution) * 2 * fBlurDist;

    // Do the blur and sum the samples
    vec4 vSum = vec4(0);
    vec2 vSamplePos = vStartPoint;
    for (int i = 0; i < NumSamples; i++)
    {
        vec2 vSampleTexCoord = vSamplePos * 0.5f + 0.5f;

        // Don't add in samples past texture border
        if (vSampleTexCoord.x >= 0 && vSampleTexCoord.x <= 1.0f
         && vSampleTexCoord.y >=0 && vSampleTexCoord.y <= 1.0f)
        {
            vec4 vSample = texture(tex, (vSampleTexCoord));
            vSum +=  max(vec4(0), vSample - fThreshold) * vTint;
        }

        vSamplePos += vStep;
    }

    fragColor = vSum / NumSamples;
    fragColor.a = 1;
}
