#version 430 core

uniform sampler2D tex;
uniform float time;
uniform float width;
uniform float height;

const float sampleDist = 0.5;
const float sampleStrength = 3.2;

in vec2 textureCoord;
out vec4 fragColor;

void main() 
{
    float samples[10];
    samples[0] = -0.08;
    samples[1] = -0.05;
    samples[2] = -0.03;
    samples[3] = -0.02;
    samples[4] = -0.01;
    samples[5] =  0.01;
    samples[6] =  0.02;
    samples[7] =  0.03;
    samples[8] =  0.05;
    samples[9] =  0.08;

    vec2 dir = 0.5 - textureCoord; 
    float dist = sqrt(dir.x*dir.x + dir.y*dir.y); 
    dir = dir/dist; 

    vec4 color = texture(tex,textureCoord); 
    vec4 sum = color;

    for (int i = 0; i < 10; i++)
        sum += texture( tex, textureCoord + dir * samples[i] * sampleDist );

    sum *= 1.0/11.0;
    float t = dist * sampleStrength;
    t = clamp( t ,0.0,1.0);

    fragColor.rgb = mix( color, sum, t ).rgb;
    fragColor.a = 1;
}
