#version 430 core

layout(binding = 0) uniform sampler2D tex;
layout(binding = 1) uniform sampler2D bloom;
uniform float time;
uniform float width;
uniform float height;

// Control exposure with this value
uniform float exposure = 2.5;

// How much bloom to add
uniform float bloomFactor;

// Max bright
uniform float brightMax = 4.0;

in vec2 textureCoord;
out vec4 fragColor;

void main() {
    vec2 st = textureCoord;
    vec4 color = texture(tex, st);
    vec4 colorBloom = texture(bloom, st);
    float alpha = colorBloom.a;


    // Add bloom to the image
    color += (colorBloom)* bloomFactor;
    
    // Perform tone-mapping
    float Y = dot(vec4(0.30, 0.59, 0.11, 0.0), color);
    float YD = exposure * (exposure/brightMax + 1.0) / (exposure + 1.0);
    color *= YD;
    
    fragColor.rgb = color.rgb;
    fragColor.a = alpha;
}