#version 430 core

uniform sampler2D tex;
uniform float time;
uniform float width;
uniform float height;

//RADIUS of our vignette, where 0.5 results in a circle fitting the screen
const float RADIUS = 0.75;

//softness of our vignette, between 0.0 and 1.0
const float SOFTNESS = 0.45;

in vec2 textureCoord;
out vec4 color;

void main() {
    //sample our texture
    vec4 texColor = texture(tex, textureCoord);

    //determine origin
    vec2 position = textureCoord - vec2(0.5);

    //determine the vector length of the center position
    float len = length(position);

    float vignette = smoothstep(RADIUS, RADIUS-SOFTNESS, len);
    texColor.rgb *= vignette;

    color = texColor;
}