#version 430 core

const float PI = 3.141592654;
const float TWOPI = 6.283185307;

uniform mat4 mvp;
uniform mat4 M;
uniform mat4 V;
uniform float morph_factor;
uniform float time;

layout(location=0) in vec3 position;
layout(location=1) in vec3 normal;
layout(location=2) in vec3 tangent;
layout(location=3) in vec3 binormal;
layout(location=4) in vec2 texCoords;
layout(location=5) in vec2 texCoords2;
layout(location=6) in vec2 texCoords3;
layout(location=7) in vec2 texCoords4;
layout(location=8) in vec4 color;
layout(location=9) in vec4 color2;
layout(location=10) in vec4 pos2;
//layout locations 10+ can be used for custom attriutes
out vec2 texCoordsVarying;
out vec4 colorVarying;
out vec3 pos_eye;
out vec3 norm_eye;

void main() {
  vec4 col = color;
  if(dot(col,col) == 1)
    col = vec4(1,1,1,1);

  pos_eye  = vec3(V * M * vec4(position,1));
  norm_eye = vec3(V * M * vec4(normal,1));

  float alpha = smoothstep(0.0, 1.0, morph_factor);
  vec4 P = (vec4(binormal,1) * alpha) + (vec4(position,1) * (1 - alpha));
  vec4 N = (vec4(tangent,1) * alpha) + (vec4(normal,1) * (1 - alpha));



  texCoordsVarying.x = atan(P.y,P.x) / TWOPI;
  if(texCoordsVarying.x < 0)
    texCoordsVarying.x = 1 + texCoordsVarying.x;
  texCoordsVarying.y = (0.5 + atan(P.z,sqrt(P.x*P.x+P.y*P.y)) / PI);
  texCoordsVarying.xy = clamp(texCoordsVarying.xy,0,1);

  //texCoordsVarying.xy *= 3;
  //texCoordsVarying.xy = clamp(texCoordsVarying.xy,0.0,0.33);
  colorVarying = col;
  gl_Position = mvp * P;

}

