//The texture loader
function TextureLoader(){

    //List of textures to be loaded
    var toBeLoaded = [
    ];

    var textures = {};
    var loader = new THREE.TextureLoader();

    var loadReady = function(callback){
        for(var i = 0; i < toBeLoaded.length; ++i){
            if(!toBeLoaded[i].loaded){
                return false;
            }
        }
        callback(textures);
    };

    var textureOnLoad = function(index, one, callback){
        var info = toBeLoaded[index];
        if(info.loaded){
            if(one){
                callback(textures[info.name.toString()]);
            }
            else{
                loadReady(callback);
            }
        }
        else{
            loader.load(info.path,
            function(texture){
                texture.mapping = info.mapping;
                texture.wrapS = info.wrapS;
                texture.wrapT = info.wrapT;
                texture.magFilter = info.magFilter;
                texture.minFilter = info.minFilter;
                texture.format = info.format;
                texture.flipY = info.flipY;

                texture.repeat.set(info.repeat[0], info.repeat[1]);
                texture.offset.set(info.offset[0], info.offset[1]);


                textures[info.name.toString()] = texture;
                info.loaded = true;

                if(one){
                    callback(texture);
                }
                else{
                    loadReady(callback);
                }
            },
            function(xhr){
                console.log( (xhr.loaded / xhr.total * 100) + "% loaded");
            },
            function ( xhr ) {
                console.log("An error happened when loading texture: ", info.name);
                //Should we just stop or continue or what to do?
            });
        }
    };

    var customLoad = function(path, callback){
        loader.load(path,
        function(texture){
            callback(texture);
        },
        function(xhr){
            console.log( (xhr.loaded / xhr.total * 100) + "% loaded");
        },
        function(xhr){
            console.log("An error happened when loading texture: ", path);
            callback(false);
        });
    };

    var t = {
        loader : loader,

        //Loads all textures in the list and then calls the function given as parameter
        loadAll : function(cb){
            if(toBeLoaded.length < 1){
                loadReady(cb);
            }
            else{
                for(var i = 0; i < toBeLoaded.length; ++i){
                    textureOnLoad(i, false, cb);
                }
            }

        },

        //Loads one texture and then calls the function given as parameter
        loadOne : function(index, cb){
            textureOnLoad(index, true, cb);
        },

        loadOther : function(path, cb){
            customLoad(path, cb);
        },

        getTextures : function(){
            return textures;
        }
    }

    return t;
};
TDEMO.TEXTURES = TextureLoader();
