//sync tracks for rocket
//dependent on config.js, JSRocket and THREE

//Only one Sync per demo!
var Sync =  function(){

    var config = Config();
    var syncDevice = new JSRocket.SyncDevice();

    var part = 0;
    var filmPassEnabled = 1;
    var brightness = 0;
    var negate = 0;
    var glitch = 0;
    var grayscale = 0;
    var fade = {
        color : {r: 0, g: 0, b: 0},
        value : 0.0
        //the value range is from 0...1 (0 no fade, 1 completely faded)
    };

    var near = 0.1;
    var far = 1000;
    var focalLength = 10;
    var filmGauge = 24;

    var heart = 1;

    var camera = {
        pos : {x: 0, y: 0, z: 0},
        rot : {x: 0, y: 0, z: 0}
    };

    var obj = {
        pos : {x: 0, y: 0, z: 0},
        rot : {x: 0, y: 0, z: 0}
    };

    var lightTarget = {x: 0, y: 0, z: 0};

    var syncInterface = {

        getPart : function(){
            return part.getValue(config.getRow());
        },

        getFilmPassEnabled : function(){
            var status = (filmPassEnabled.getValue(config.getRow()) || 0);
            if(status === 0){
                return false;
            }
            return true;
        },

        getBrightness : function(){
            return (brightness.getValue(config.getRow()) || 0);
        },

        getNegate : function(){
            return (negate.getValue(config.getRow()) || 0);
        },

        getGlitch : function(){
            return (glitch.getValue(config.getRow()) || 0);
        },

        getGrayscale : function(){
            return (grayscale.getValue(config.getRow()) || 0);
        },

        getFadeColor : function(){
            var r = fade.color.r.getValue(config.getRow());
            var g = fade.color.g.getValue(config.getRow());
            var b = fade.color.b.getValue(config.getRow());

            return new THREE.Vector3(r, g, b);
        },

        getFadeValue : function(){
            var value = fade.value.getValue(config.getRow());
            return value;
        },

        getNear : function(){
            return near.getValue(config.getRow());
        },

        getFar : function(){
            return far.getValue(config.getRow());
        },

        getLens : function(){
            var fl = focalLength.getValue(config.getRow());
            var fg = filmGauge.getValue(config.getRow());
            return{
                fl : fl,
                fg : fg
            };
        },

        getHeartBeat : function(){
            return heart.getValue(config.getRow());
        },

        getCameraPosition : function(){
            var x = camera.pos.x.getValue(config.getRow());
            var y = camera.pos.y.getValue(config.getRow());
            var z = camera.pos.z.getValue(config.getRow());

            return new THREE.Vector3(x,y,z);
        },

        getCameraRotation : function(){
            var x = camera.rot.x.getValue(config.getRow());
            var y = camera.rot.y.getValue(config.getRow());
            var z = camera.rot.z.getValue(config.getRow());

            return new THREE.Vector3(x,y,z);
        },

        getObjPosition : function(){
            var x = obj.pos.x.getValue(config.getRow());
            var y = obj.pos.y.getValue(config.getRow());
            var z = obj.pos.z.getValue(config.getRow());

            return new THREE.Vector3(x,y,z);
        },

        getObjRotation : function(){
            var x = obj.rot.x.getValue(config.getRow());
            var y = obj.rot.y.getValue(config.getRow());
            var z = obj.rot.z.getValue(config.getRow());

            return new THREE.Vector3(x,y,z);
        },

        getLightTarget : function(){
            var x = lightTarget.x.getValue(config.getRow());
            var y = lightTarget.y.getValue(config.getRow());
            var z = lightTarget.z.getValue(config.getRow());

            return new THREE.Vector3(x,y,z);
        },

        //Binding tracks
        bindTracks : function(){

            part = syncDevice.getTrack('part');
            filmPassEnabled = syncDevice.getTrack('film_on');
            brightness = syncDevice.getTrack('brightness');
            negate = syncDevice.getTrack('negate');
            glitch = syncDevice.getTrack('glitch');
            grayscale = syncDevice.getTrack('grayscale');

            //fade
            fade.color.r = syncDevice.getTrack('fade_col_r');
            fade.color.g = syncDevice.getTrack('fade_col_g');
            fade.color.b = syncDevice.getTrack('fade_col_b');

            fade.value = syncDevice.getTrack('fade');

            near = syncDevice.getTrack('near');
            far = syncDevice.getTrack('far');
            focalLength = syncDevice.getTrack('focal_length');
            filmGauge = syncDevice.getTrack('film_gauge');

            //Heart Beat
            heart = syncDevice.getTrack('heart_beat');

            //CAMERA
            camera.pos.x = syncDevice.getTrack('cam_x');
            camera.pos.y = syncDevice.getTrack('cam_y');
            camera.pos.z = syncDevice.getTrack('cam_z');

            camera.rot.x = syncDevice.getTrack('cam_rot_x');
            camera.rot.y = syncDevice.getTrack('cam_rot_y');
            camera.rot.z = syncDevice.getTrack('cam_rot_z');

            //OBJECT
            obj.pos.x = syncDevice.getTrack('obj_x');
            obj.pos.y = syncDevice.getTrack('obj_y');
            obj.pos.z = syncDevice.getTrack('obj_z');

            obj.rot.x = syncDevice.getTrack('obj_rot_x');
            obj.rot.y = syncDevice.getTrack('obj_rot_y');
            obj.rot.z = syncDevice.getTrack('obj_rot_z');

            lightTarget.x = syncDevice.getTrack('l_target_x');
            lightTarget.y = syncDevice.getTrack('l_target_y');
            lightTarget.z = syncDevice.getTrack('l_target_z');
        },

        //Initializes the sync device and returns it
        initSyncDevice : function(){
            if(config.isDemoMode()){
                syncDevice.setConfig({'rocketXML': config.getXML()});
                syncDevice.init("demo");
            } else {
                //config.syncDevice.setConfig({'socketURL':'ws://192.168.0.100:1338'});
                syncDevice.init();
            }
            return syncDevice;
        },

        //returns the sync device
        getSyncDevice : function(){
            return syncDevice;
        },

        getConfig : function(){
            return config;
        }


    };

    return syncInterface;
};

TDEMO.SYNC = Sync();
