 var Efekti = function(){
    var size = TDEMO.MAIN.getRendererSize();
    PartBase.call(this, {camera : new THREE.OrthographicCamera( -size[0]/2, size[0]/2, size[1]/2, -size[1]/2, 0.01, 40 )});
    this.camera.position.z = 1;

    //POSTPROCESSING

    this.setBloom(0.1);

    this.shaderScene = new THREE.Scene();
    var aspect = this.width/this.height;
    this.shaderCamera = new THREE.PerspectiveCamera(50, aspect, this.near, this.far);

    this.shaderScene.add(this.shaderCamera);

    this.shader = this.initShader({
        resolution : new THREE.Vector2(this.width, this.height),
        time : 0,
        hb : 0,
        fov : this.shaderCamera.getEffectiveFOV(),
        fogColor : new THREE.Vector3(0.6, 0.6, 0.6),
        ro : this.shaderCamera.position,
        target: this.shaderCamera.rotation
    });
    var geometry = new THREE.PlaneBufferGeometry(this.width, this.height);
    this.plane = new THREE.Mesh(geometry, this.shader);
    //this.plane.position.z = -1;

    this.scene.add(this.plane);
};

Efekti.prototype = PartBase.prototype.inheritance();

Efekti.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, false);

    this.shader.uniforms.fov.value = this.shaderCamera.getEffectiveFOV();
    this.shader.uniforms.time.value = elapsedTime;

    var hb = TDEMO.SYNC.getHeartBeat();
    this.shader.uniforms.hb.value = hb;
    

    this.lens = TDEMO.SYNC.getLens();
    this.shaderCamera.filmGauge = this.lens.fg;
    this.shaderCamera.setFocalLength(this.lens.fl);

    //Animating camera position
    var camp = TDEMO.SYNC.getCameraPosition();
    this.shaderCamera.position.x = camp.x;
    this.shaderCamera.position.y = camp.y;
    this.shaderCamera.position.z =  camp.z;

    var camr = TDEMO.SYNC.getCameraRotation();
    this.shaderCamera.rotation.x = camr.x;
    this.shaderCamera.rotation.y = camr.y;
    this.shaderCamera.rotation.z =  camr.z;

    this.shader.uniforms.ro.value = this.shaderCamera.position;
    this.shader.uniforms.target.value = this.shaderCamera.rotation;
};

Efekti.prototype.initShader = function(uf){

    var uniforms = {
        resolution : {type: "v2", value: uf.resolution},
        time : {type: "f", value : uf.time},
        hb : {type: "f", value : uf.hb},
        fov : {type : "f", value : uf.fov},
        fogColor : {type: "v3", value: uf.fogColor},

        ro : {type : "v3", value: uf.ro},
        target : {type : "v3", value: uf.target},
    };

    var vertex = [
        "varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"
    ].join("\n");

    var fragment = [
        "#define STEPS 64",
        "#define FAR 40.0",

        //"#define saturate(x) clamp(x, 0, 1)",

        "uniform vec2 resolution;",
        "uniform float time;",
        "uniform float hb;",
        "uniform float fov;",
        "uniform vec3 fogColor;",

        "uniform vec3 ro;",
        "uniform vec3 target;",

        "varying vec2 vUv;",

        // Sign function that doesn't return 0
        "float sgn(float x) {",
        	"return (x<0.0)?-1.0:1.0;",
        "}",

        "float box( vec3 p, vec3 b ){",
            "vec3 d = abs(p) - b;",
            "return min(max(d.x,max(d.y,d.z)),0.0)+length(max(d,0.0));",
        "}",

        "float noise(vec3 p){",
            "vec3 ip = floor(p);",
            "p -= ip;",
            "vec3 s = vec3(7.0,157.0,113.0);",
            "vec4 h = vec4(0.0, s.yz, s.y+s.z)+dot(ip, s);",
            "p = p*p*(3.0-2.0*p);",
            "h = mix(fract(sin(h)*43758.5), fract(sin(h+s.x)*43758.5), p.x);",
            "h.xy = mix(h.xz, h.yw, p.y);",
            "return mix(h.x, h.y, p.z);",
        "}",



        "float sdf(vec3 p){",
            "return -box(p, vec3(6.0, 4.0, 400.0))-noise((p+time*hb)*0.5);",
        "}",

        //calculate normals for objects
        "vec3 normals(vec3 p){",
            "vec3 eps = vec3(0.5/resolution.x, 0.0, 0.0 );",
            "vec3 nor = vec3(",
                "sdf(p+eps.xyy) - sdf(p-eps.xyy),",
                "sdf(p+eps.yxy) - sdf(p-eps.yxy),",
                "sdf(p+eps.yyx) - sdf(p-eps.yyx));",
            "return normalize(nor);",
        "}",

        //Enhanced sphere tracing algorithm introduced by Mercury
        "float march(in vec3 ro, in vec3 rd){",
            "vec3 p = vec3(0.);",
            "float t = .0001;",
            "float step = 0.;",

            "float omega = 1.2;",//muista testata eri arvoilla! [1,2]
            "float prev_radius = 0.;",

            "float candidate_t = t;",
            "float candidate_error = 1000.;",
            "float sg = sgn(sdf(ro));",

            //It's just so much better with static value!
            "float pixelr = 0.5/resolution.x;",

            "for(int i = 0; i < STEPS; ++i){",
                "p = rd*t+ro;",
                "float sg_radius = sg*sdf(p);",
                "float radius = abs(sg_radius);",

                "bool fail = omega > 1. && (radius+prev_radius) < step;",
                "if(fail){",
                    "step -= omega * step;",
                    "omega = 1.;",
                "}",
                "else{",
                    "step = sg_radius*omega;",
                "}",
                "prev_radius = radius;",
                "float error = radius/t;",

                "if(!fail && error < candidate_error){",
                    "candidate_t = t;",
                    "candidate_error = error;",
                "}",

                "if(!fail && error < pixelr || t > FAR){",
                    "break;",
                "}",
                "t += step;",
            "}",

            //discontinuity reduction
            "float er = candidate_error;",
            "for(int j = 0; j < 6; ++j){",
                "float radius = abs(sg*sdf(p));",
                "p = p + rd*(radius-er);",
                "t = length(p-ro);",
                "er = radius/t;",

                "if(er < candidate_error){",
                    "candidate_t = t;",
                    "candidate_error = er;",
                "}",
            "}",

            "if(t > FAR || candidate_error > pixelr){",
                "return FAR;",
            "}",
            "return candidate_t;",
        "}",

        //Ambien occlusion & shadow coeffience function modified from las's (Mercury)
        //and dechipher's (YUP) methods
        //PRAMETERS:
        //  p = position,
        //  n = normals (ao) or unit vector of light direction (shadow)
        //  k = constant
        "float ambientOcclusion(vec3 p, vec3 n, float k){",
            "float s = sgn(k);",
            "float ro = s*0.5+0.5;",
            "for(float i = 0.0; i < 6.0; ++i){",
                "ro -= (i*k - sdf(p+n*i*k*s))/exp2(i);",
            "}",
            "return max(min(ro, 1.0), 0.0);",
        "}",

        //Iq's procedural palette generation
        //http://www.iquilezles.org/www/articles/palettes/palettes.htm
        /*vec3 palette(float t, vec3 a, vec3 b, vec3 c, vec3 d ){
            return a + b*cos( 6.28318*(c*t+d) );
        }*/

        "vec3 colorify(vec3 ld, vec3 p, vec3 lc){",
            "vec3 n = normals(p);",
            "vec3 ambient = vec3(0.0, 0.0, 0.8)*smoothstep(0.0, 1.0, noise(p*time*0.5));",
            "return (lc + ambient) *",
                "ambientOcclusion(p, n, 0.5) *",
                "ambientOcclusion(p, ld, 0.6) * 0.5;",
        "}",

        "vec3 fog(vec3 col, vec3 p, vec3 ro, vec3 rd, vec3 ld, vec3 lc){",
            "float dist = length(p-ro);",
            "float sunAmount = max( dot( rd, ld ), 0.0 );",
            "float fogAmount = 1.0 - exp( -dist*0.06);",
            "vec3  fg = mix(fogColor, lc, pow(sunAmount, 6.0));",
            "return mix(col, fg, fogAmount);",
        "}",

        // Functio to set camera
        // o = camera origin
        // target = camera target (lookAt)
        // cr = right angle
        "mat3 setCamera(vec3 o, vec3 t, float cr ){",
        	"vec3 cw = normalize(t-o);",//z
        	"vec3 cp = vec3(sin(cr), cos(cr),0.0);",//up
        	"vec3 cu = normalize( cross(cw,cp) );",//x
        	"vec3 cv = normalize( cross(cu,cw) );",//y

            "return mat3( cu, cv, cw );",
        "}",

        "void main(){",
            "vec2 q = vUv;//gl_FragCoord.xy/resolution;",
            "vec2 v = -1.0+2.0*q;//screenspace coordinates -1..1",
            "v.x *= resolution.x/resolution.y;//aspect correction",

            "mat3 cam = setCamera(ro, target, 0.0);",
        	"vec3 rd = normalize(cam*vec3(v.xy, radians(fov)));",


            "float t = march(ro, rd);",
            "vec3 p = rd*t+ro;",

            "gl_FragColor = vec4(fogColor, 1.0);",
            
            "vec3 lo2 = -target;",
            "vec3 lo3 = vec3(-1.0, ro.y, 1.0);",
            "vec3 ld = (ro-target)/distance(target, ro);",
            "vec3 ld2 = (target-lo2)/distance(lo2, target);",
            "vec3 ld3 = (ro-lo3)/distance(lo3, ro);",

            "if(t < FAR){",
                "gl_FragColor.xyz = colorify(ld, p, vec3(0.0, 0.5, 1.0)) +",
                    "colorify(ld2, p, vec3(0.5, 0.0, 0.8)) +",
                    "colorify(ld3, p, vec3(0.9, 0.3, 0.5));",
                "gl_FragColor.xyz /= 3.0;",
            "}",
            "vec3 fg = fog(gl_FragColor.xyz, p, ro, rd, ld, vec3(0.0, 0.5, 1.0)) +",
                "fog(gl_FragColor.xyz, p, ro, rd, ld2, vec3(0.5, 0.0, 0.8)) +",
                "fog(gl_FragColor.xyz, p, ro, rd, ld3, vec3(0.9, 0.3, 0.5));",
            "gl_FragColor.xyz = fg*0.25;",
            "gl_FragColor.xyz = smoothstep(0.01, 0.98, gl_FragColor.xyz);",
            //fog(gl_FragColor.xyz, p, ro, rd, ld, vec3(0.2, 0.2, 0.4));",
        "}",

    ].join("\n");

    var material = new THREE.ShaderMaterial( {
        uniforms : uniforms,
        vertexShader: vertex,
        fragmentShader: fragment,
    } );

    return material;
}
