/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PVector;

public class bjakke_assembly_2018
extends PApplet {
    boolean ENTRY_MODE = true;
    int BPM = 140;
    Moonlander moonlander;
    int CANVAS_WIDTH = 640;
    int CANVAS_HEIGHT = 360;
    int FONT_SIZE = 16;
    int FONT_PARSER_WIDTH = 16;
    int FONT_PARSER_HEIGHT = 16;
    int FONT_TOTAL_CELLS = this.FONT_PARSER_WIDTH * this.FONT_PARSER_HEIGHT;
    int FONT_OUTPUT_LETTER_SPACING = 200;
    int FONT_OUTPUT_DOT_SPACING = 14;
    int FONT_OUTPUT_RECT_SIZE = 12;
    int MAX_LETTERS_PER_ROW = 20;
    ArrayList<PVector> TEXT1 = new ArrayList();
    ArrayList<PVector> TEXT2 = new ArrayList();
    ArrayList<PVector> TEXT3 = new ArrayList();
    ArrayList<PVector> TEXT4 = new ArrayList();
    ArrayList<PVector> TEXT5 = new ArrayList();
    ArrayList<PVector> TEXT6 = new ArrayList();
    HashMap<String, boolean[]> FONT_DATA = new HashMap();
    PFont LETTER_FONT;

    public void settings() {
        if (this.ENTRY_MODE) {
            this.fullScreen("processing.opengl.PGraphics2D");
        } else {
            this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics2D");
        }
    }

    public boolean[] createPositionDataForLetter(String letter) {
        boolean[] r = new boolean[this.FONT_TOTAL_CELLS];
        int r_index = 0;
        PGraphics tmp = this.createGraphics(this.FONT_PARSER_WIDTH, this.FONT_PARSER_HEIGHT, "processing.opengl.PGraphics2D");
        tmp.beginDraw();
        tmp.textFont(this.LETTER_FONT);
        tmp.background(255);
        tmp.fill(0);
        tmp.textAlign(37, 101);
        tmp.textSize((float)this.FONT_SIZE);
        tmp.text(letter, 0.0f, 0.0f);
        tmp.endDraw();
        tmp.loadPixels();
        int i = 0;
        while (i < this.FONT_PARSER_HEIGHT) {
            ArrayList<String> t = new ArrayList<String>();
            int j = 0;
            while (j < this.FONT_PARSER_WIDTH) {
                int index = i * this.FONT_PARSER_WIDTH + j;
                int c = tmp.pixels[index];
                if (this.red(c) > 127.0f) {
                    r[r_index] = false;
                    t.add(" ");
                } else {
                    r[r_index] = true;
                    t.add("X");
                }
                ++r_index;
                ++j;
            }
            bjakke_assembly_2018.println(t);
            ++i;
        }
        return r;
    }

    public void setup() {
        this.LETTER_FONT = this.createFont("Arial", this.FONT_SIZE);
        String data = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c5\u00c4\u00d6 1234567890!?|_-";
        int letter = 0;
        while (letter < data.length()) {
            String data2 = "" + data.charAt(letter);
            bjakke_assembly_2018.println((String)data2);
            this.FONT_DATA.put(data2, this.createPositionDataForLetter(data2));
            ++letter;
        }
        bjakke_assembly_2018.println((String)"");
        this.TEXT1 = this.textToLocations("HELLO", -600, -400, this.TEXT1);
        this.TEXT1 = this.textToLocations("WORLD!", -600, 0, this.TEXT1);
        this.TEXT2 = this.textToLocations("WELCOME ", -800, -400, this.TEXT2);
        this.TEXT2 = this.textToLocations("ASSEMBLY!", -800, 0, this.TEXT2);
        this.TEXT3 = this.textToLocations("CUBE", -800, -400, this.TEXT3);
        this.TEXT3 = this.textToLocations("TEXT", -800, 0, this.TEXT3);
        this.TEXT4 = this.textToLocations("-------", -800, -600, this.TEXT4);
        this.TEXT4 = this.textToLocations("-------", -800, -300, this.TEXT4);
        this.TEXT4 = this.textToLocations("-------", -800, 0, this.TEXT4);
        this.TEXT4 = this.textToLocations("-------", -800, 300, this.TEXT4);
        this.TEXT4 = this.textToLocations("| | | |", -800, -400, this.TEXT4);
        this.TEXT4 = this.textToLocations("| | | |", -800, -100, this.TEXT4);
        this.TEXT4 = this.textToLocations("| | | |", -800, 200, this.TEXT4);
        this.TEXT5 = this.textToLocations("-------", -800, -600, this.TEXT5);
        this.TEXT5 = this.textToLocations("-------", -800, -300, this.TEXT5);
        this.TEXT5 = this.textToLocations("-------", -800, 0, this.TEXT5);
        this.TEXT5 = this.textToLocations("-------", -800, 300, this.TEXT5);
        this.TEXT5 = this.textToLocations("| |X|O|", -800, -400, this.TEXT5);
        this.TEXT5 = this.textToLocations("| |X|O|", -800, -100, this.TEXT5);
        this.TEXT5 = this.textToLocations("| |X| |", -800, 200, this.TEXT5);
        this.TEXT6 = this.textToLocations("EPIC", -600, -400, this.TEXT6);
        this.TEXT6 = this.textToLocations("VICTORY", -600, 0, this.TEXT6);
        this.frameRate(60.0f);
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"musa3.wav", (int)this.BPM, (int)8);
        if (this.ENTRY_MODE) {
            this.noCursor();
            this.moonlander.start("data/assembly2018.rocket");
        } else {
            this.moonlander.start("localhost", 1338, "data/assembly2018.rocket");
        }
    }

    public ArrayList<PVector> textToLocations(String text, int startX, int startY) {
        return this.textToLocations(text, startX, startY, new ArrayList<PVector>());
    }

    public ArrayList<PVector> textToLocations(String text, int startX, int startY, ArrayList<PVector> r) {
        int letterStartX = startX;
        int letterStartY = startY;
        int i = 0;
        while (i < text.length()) {
            String letter = "" + text.charAt(i);
            int x = letterStartX;
            int y = letterStartY;
            int dataIter = 0;
            boolean[] data = this.FONT_DATA.get(letter);
            int lY = 0;
            while (lY < this.FONT_PARSER_HEIGHT) {
                y += this.FONT_OUTPUT_DOT_SPACING;
                x = letterStartX;
                int lX = 0;
                while (lX < this.FONT_PARSER_WIDTH) {
                    x += this.FONT_OUTPUT_DOT_SPACING;
                    if (data[dataIter]) {
                        r.add(new PVector((float)x, (float)y));
                    }
                    ++dataIter;
                    ++lX;
                }
                ++lY;
            }
            letterStartX += this.FONT_OUTPUT_LETTER_SPACING;
            ++i;
        }
        return r;
    }

    public void visualizeDot(PVector pos) {
        this.rectMode(3);
        this.fill(255);
        this.rect(pos.x, pos.y, this.FONT_OUTPUT_RECT_SIZE, this.FONT_OUTPUT_RECT_SIZE);
    }

    public void visualize(ArrayList<PVector> data) {
        for (PVector vec : data) {
            this.visualizeDot(vec);
        }
    }

    public ArrayList<PVector> calcStartingPoints(ArrayList<PVector> textStart, ArrayList<PVector> textEnd) {
        ArrayList<PVector> r = new ArrayList<PVector>();
        ArrayList<PVector> options = new ArrayList<PVector>();
        for (PVector v : textEnd) {
            if (options.isEmpty()) {
                for (PVector tmp : textStart) {
                    options.add(tmp);
                }
            }
            PVector chosen = (PVector)options.get(0);
            float chosenLen = 1.0E12f;
            for (PVector opt : options) {
                float len = v.dist(opt);
                if (!(len < chosenLen)) continue;
                chosen = opt;
                chosenLen = len;
            }
            options.remove(chosen);
            r.add(chosen);
        }
        return r;
    }

    public void textTransform(float change, ArrayList<PVector> text1, ArrayList<PVector> text2) {
        ArrayList<PVector> s2 = new ArrayList<PVector>();
        ArrayList<PVector> actualEnd = new ArrayList<PVector>();
        for (PVector v : text2) {
            actualEnd.add(v);
        }
        int c = 0;
        while (actualEnd.size() < text1.size()) {
            actualEnd.add(actualEnd.get(c));
            ++c;
        }
        ArrayList<PVector> sp = this.calcStartingPoints(text1, actualEnd);
        int i = 0;
        while (i < actualEnd.size()) {
            PVector s1 = sp.get(i);
            PVector s = actualEnd.get(i);
            s2.add(new PVector(bjakke_assembly_2018.map((float)change, (float)0.0f, (float)1.0f, (float)s1.x, (float)s.x), bjakke_assembly_2018.map((float)change, (float)0.0f, (float)1.0f, (float)s1.y, (float)s.y)));
            ++i;
        }
        this.visualize(s2);
    }

    public void scene5() {
        this.textTransform(1.0f, this.TEXT3, this.TEXT4);
        ArrayList<PVector> txt5 = new ArrayList<PVector>();
        int phase = this.moonlander.getIntValue("change");
        String s1 = "| | | |";
        String s2 = "| | | |";
        String s3 = "| | | |";
        if (phase > 0) {
            s1 = "| |X| |";
        }
        if (phase > 1) {
            s1 = "| |X|O|";
        }
        if (phase > 2) {
            s2 = "| |X| |";
        }
        if (phase > 3) {
            s2 = "| |X|O|";
        }
        if (phase > 4) {
            s3 = "| |X| |";
        }
        txt5 = this.textToLocations(s1, -800, -400, txt5);
        txt5 = this.textToLocations(s2, -800, -100, txt5);
        txt5 = this.textToLocations(s3, -800, 200, txt5);
        this.visualize(txt5);
    }

    public void draw() {
        float change;
        this.moonlander.update();
        this.moonlander.getCurrentTime();
        this.translate(this.width / 2, this.height / 2);
        this.scale((float)this.height / 1000.0f);
        this.background(0);
        new ArrayList();
        int scene = this.moonlander.getIntValue("scene");
        if (scene == 1) {
            float s1test = (float)this.moonlander.getValue("change");
            ArrayList<PVector> s1 = new ArrayList<PVector>();
            for (PVector vec : this.TEXT1) {
                s1.add(new PVector(bjakke_assembly_2018.map((float)s1test, (float)0.0f, (float)1.0f, (float)0.0f, (float)vec.x), bjakke_assembly_2018.map((float)s1test, (float)0.0f, (float)1.0f, (float)0.0f, (float)vec.y)));
            }
            this.visualize(s1);
        }
        if (scene == 2) {
            float s2test = (float)this.moonlander.getValue("change");
            this.textTransform(s2test, this.TEXT1, this.TEXT2);
        }
        if (scene == 3) {
            change = (float)this.moonlander.getValue("change");
            this.textTransform(change, this.TEXT2, this.TEXT3);
        }
        if (scene == 4) {
            change = (float)this.moonlander.getValue("change");
            this.textTransform(change, this.TEXT3, this.TEXT4);
        }
        if (scene == 5) {
            this.scene5();
        }
        if (scene == 6) {
            change = (float)this.moonlander.getValue("change");
            this.textTransform(change, this.TEXT5, this.TEXT6);
        }
        if (scene > 6) {
            this.exit();
        }
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"bjakke_assembly_2018"};
        if (passedArgs != null) {
            PApplet.main((String[])bjakke_assembly_2018.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

