/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import java.util.ArrayList;
import moonlander.library.ControllerListener;

abstract class Controller {
    protected double currentRow = 0.0;
    protected double rowsPerSecond;
    private boolean playing;
    ArrayList<ControllerListener> listeners = new ArrayList();

    public Controller(double rps) {
        this.rowsPerSecond = rps;
        this.playing = false;
    }

    public void addEventListener(ControllerListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(ControllerListener listener) {
        this.listeners.remove(listener);
    }

    public double getCurrentRow() {
        return this.currentRow;
    }

    public double getCurrentTime() {
        return this.currentRow / this.rowsPerSecond;
    }

    public void setCurrentRow(double row, boolean silent) {
        if ((int)row != (int)this.currentRow && !silent) {
            for (ControllerListener listener : this.listeners) {
                listener.controllerRowChanged((int)row);
            }
        }
        this.currentRow = row;
    }

    public abstract void update();

    public boolean isPlaying() {
        return this.playing;
    }

    private void setPlayState(boolean status) {
        if (status != this.playing) {
            this.playing = status;
            for (ControllerListener listener : this.listeners) {
                listener.controllerStatusChanged(status);
            }
        }
    }

    public void pause() {
        this.setPlayState(false);
    }

    public void play() {
        this.setPlayState(true);
    }
}

