/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import ddf.minim.AudioPlayer;
import moonlander.library.Controller;

public class MinimController
extends Controller {
    AudioPlayer player;

    public MinimController(AudioPlayer player, int beatsPerMinute, int rowsPerBeat) {
        super((double)beatsPerMinute / 60.0 * (double)rowsPerBeat);
        this.player = player;
    }

    @Override
    public void update() {
        if (this.isPlaying()) {
            this.setCurrentRow((double)this.player.position() / 1000.0 * this.rowsPerSecond, false);
        }
    }

    @Override
    public void pause() {
        super.pause();
        this.player.pause();
    }

    @Override
    public void play() {
        super.play();
        this.player.cue((int)(this.getCurrentRow() * 1000.0 / this.rowsPerSecond));
        this.player.play();
    }
}

