/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import java.io.File;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import moonlander.library.Connector;
import moonlander.library.Controller;
import moonlander.library.Track;
import moonlander.library.TrackContainer;
import moonlander.library.TrackKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ProjectFileConnector
extends Connector {
    public ProjectFileConnector(Logger logger, TrackContainer tracks, Controller controller, String path) throws Exception {
        super(logger, tracks, controller);
        try {
            this.readAndLoadTracks(path);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        controller.play();
    }

    private void readAndLoadTracks(String path) throws Exception {
        this.logger.info("Loading tracks from '" + path + "'.");
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(path));
        NodeList trackList = doc.getElementsByTagName("track");
        int totalTracks = trackList.getLength();
        this.logger.finer("Total number of tracks: " + totalTracks);
        for (int s = 0; s < totalTracks; ++s) {
            Element trackElement = (Element)trackList.item(s);
            NodeList keyList = trackElement.getElementsByTagName("key");
            if (keyList.getLength() <= 0) continue;
            Track track = this.tracks.getOrCreate(trackElement.getAttribute("name"));
            int totalKeys = keyList.getLength();
            this.logger.finest("Loading track (name=" + trackElement.getAttribute("name") + " keys=" + totalKeys + ")");
            for (int i = 0; i < keyList.getLength(); ++i) {
                Element key = (Element)keyList.item(i);
                int row = Integer.parseInt(key.getAttribute("row"));
                float value = Float.parseFloat(key.getAttribute("value"));
                int keyType = Integer.parseInt(key.getAttribute("interpolation"));
                track.addOrUpdateKey(new TrackKey(row, value, keyType));
            }
        }
    }

    @Override
    public void update() {
    }
}

