/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Logger;
import moonlander.library.Connector;
import moonlander.library.Controller;
import moonlander.library.Track;
import moonlander.library.TrackContainer;
import moonlander.library.TrackKey;

class SocketConnector
extends Connector {
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;
    private final String CLIENT_GREET = "hello, synctracker!";
    private final String SERVER_GREET = "hello, demo!";

    public SocketConnector(Logger logger, TrackContainer tracks, Controller controller, String host, int port) throws Exception {
        super(logger, tracks, controller);
        logger.fine(String.format("Trying to connect to Rocket at %s:%d", host, port));
        int triesAmount = 10;
        for (int i = 0; i < triesAmount; ++i) {
            try {
                this.initSocket(host, port);
                this.greetServer();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (i >= triesAmount - 1 || this.socket == null) {
                    logger.warning("SocketConnector failed to connect to Rocket the last time.");
                    this.close();
                    throw e;
                }
                logger.warning("SocketConnector failed to connect to Rocket. Trying again.");
                this.socket.close();
                continue;
            }
        }
        logger.info(String.format("Successfully connected to Rocket running at %s:%d.", host, port));
    }

    private void initSocket(String host, int port) throws Exception {
        try {
            this.socket = new Socket(host, port);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.warning(String.format("Connection to %s:%d failed.", host, port));
            throw e;
        }
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.logger.finer("Connection to Rocket established.");
    }

    private void greetServer() throws Exception {
        this.logger.finer("Sending greetings to Rocket.");
        this.out.writeBytes("hello, synctracker!");
        this.out.flush();
        this.logger.finer("Greetings sent. Now reading greetings from Rocket...");
        byte[] greet = new byte["hello, demo!".length()];
        try {
            this.in.readFully(greet, 0, "hello, demo!".length());
        }
        catch (Exception e) {
            this.logger.severe("Couldn't read greetings from server. " + e);
            throw new Exception("Reading greetings failed", e);
        }
        this.logger.finer("Greetings read successfully.");
        if (!"hello, demo!".equals(new String(greet))) {
            this.logger.severe("Server didn't send correct greetings., received: " + new String(greet));
            throw new Exception("Greetings mismatch");
        }
    }

    @Override
    public void update() {
        try {
            this.readCommand();
        }
        catch (Exception e) {
            this.logger.severe("Error in readCommand");
        }
    }

    @Override
    public void trackAdded(String name) {
        this.logger.finest("Adding track. Sending Commands.GET_TRACK to Rocket.");
        try {
            this.out.writeByte(2);
            this.out.writeInt(name.length());
            this.out.writeBytes(name);
            this.out.flush();
        }
        catch (Exception e) {
            this.logger.severe("Communication with Rocket failed!");
        }
        this.logger.finer("New track fetched from Rocket.");
    }

    @Override
    public void controllerStatusChanged(boolean isPlaying) {
    }

    @Override
    public void controllerRowChanged(int row) {
        this.logger.finest("Communicating row=" + row + " change to rocket");
        try {
            this.out.writeByte(3);
            this.out.writeInt(row);
            this.out.flush();
        }
        catch (Exception e) {
            this.logger.severe("Communication with Rocket failed!");
        }
    }

    public void handleCommandSetKey() throws IOException {
        this.logger.finest("Handling SET_KEY");
        int trackId = this.in.readInt();
        int row = this.in.readInt();
        float value = this.in.readFloat();
        byte type = this.in.readByte();
        Track t = this.tracks.getById(trackId);
        if (t != null) {
            t.addOrUpdateKey(new TrackKey(row, value, type));
        }
    }

    public void handleCommandDeleteKey() throws IOException {
        this.logger.finest("Handling DELETE_KEY");
        int trackId = this.in.readInt();
        int row = this.in.readInt();
        Track t = this.tracks.getById(trackId);
        if (t != null) {
            t.deleteKey(row);
        }
    }

    public void handleCommandSetRow() throws IOException {
        this.logger.finest("Handling SET_ROW");
        int row = this.in.readInt();
        this.controller.setCurrentRow(row, true);
    }

    public void handleCommandPause() throws IOException {
        this.logger.finest("Handling PAUSE");
        byte flag = this.in.readByte();
        if (flag > 0) {
            this.controller.pause();
        } else {
            this.controller.play();
        }
    }

    public void handleCommandSaveTracks() throws IOException {
        this.logger.finest("Handling SAVE_TRACKS");
    }

    private void readCommand() throws Exception {
        block7: while (this.in.available() != 0) {
            this.logger.finest("Available bytes from Rocket: " + this.in.available());
            byte cid = this.in.readByte();
            switch (cid) {
                case 0: {
                    this.handleCommandSetKey();
                    continue block7;
                }
                case 1: {
                    this.handleCommandDeleteKey();
                    continue block7;
                }
                case 3: {
                    this.handleCommandSetRow();
                    continue block7;
                }
                case 4: {
                    this.handleCommandPause();
                    continue block7;
                }
                case 5: {
                    this.handleCommandSaveTracks();
                    continue block7;
                }
            }
            this.logger.warning(String.format("Unknown command id=%d", cid));
        }
    }

    private static class Commands {
        static final int SET_KEY = 0;
        static final int DELETE_KEY = 1;
        static final int GET_TRACK = 2;
        static final int SET_ROW = 3;
        static final int PAUSE = 4;
        static final int SAVE_TRACKS = 5;

        private Commands() {
        }
    }
}

