/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moonlander.library.TrackKey;

public class Track {
    private String name;
    private ArrayList<TrackKey> keys;

    public Track(String name) {
        this.name = name;
        this.keys = new ArrayList();
    }

    protected List<TrackKey> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    private int getKeyIndex(int row) {
        int index = Collections.binarySearch(this.keys, new TrackKey(row, 0.0f, TrackKey.KeyType.STEP));
        if (index >= 0 || index == -1) {
            return index;
        }
        return -index - 2;
    }

    private int getKeyIndexExact(int row) {
        int index = this.getKeyIndex(row);
        if (index >= 0 && this.keys.get(index).getRow() == row) {
            return index;
        }
        return -1;
    }

    protected TrackKey getKey(int row) {
        int index = this.getKeyIndex(row);
        if (index >= 0) {
            return this.keys.get(index);
        }
        return null;
    }

    protected void addOrUpdateKey(TrackKey key) {
        int index = this.getKeyIndexExact(key.getRow());
        if (index >= 0) {
            this.keys.set(index, key);
        } else {
            this.keys.add(key);
            Collections.sort(this.keys);
        }
    }

    protected void deleteKey(int row) {
        int index = this.getKeyIndexExact(row);
        if (index >= 0) {
            this.keys.remove(index);
        }
    }

    public void printKeys() {
        for (TrackKey key : this.keys) {
            System.out.println(key);
        }
    }

    public double getValue(double row) {
        if (this.keys.size() == 0) {
            return 0.0;
        }
        int irow = (int)row;
        int idx = this.getKeyIndex(irow);
        if (idx == -1) {
            return 0.0;
        }
        if (idx == this.keys.size() - 1) {
            return this.keys.get(idx).getValue();
        }
        return TrackKey.interpolate(this.keys.get(idx), this.keys.get(idx + 1), row);
    }

    public String toString() {
        return String.format("Track(name=%s, keys=%d)", this.name, this.keys.size());
    }
}

