import moonlander.library.*;

import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;


boolean ENTRY_MODE = true;

int BPM = 140;

Moonlander moonlander;

int CANVAS_WIDTH = 640;
int CANVAS_HEIGHT = 360;

//font related
int FONT_SIZE = 16;
int FONT_PARSER_WIDTH = 16;
int FONT_PARSER_HEIGHT = 16;
int FONT_TOTAL_CELLS = FONT_PARSER_WIDTH*FONT_PARSER_HEIGHT;

int FONT_OUTPUT_LETTER_SPACING = 200;
int FONT_OUTPUT_DOT_SPACING = 14;
int FONT_OUTPUT_RECT_SIZE = 12;

int MAX_LETTERS_PER_ROW = 20;


ArrayList<PVector> TEXT1 = new ArrayList<PVector>();
ArrayList<PVector> TEXT2 = new ArrayList<PVector>();
ArrayList<PVector> TEXT3 = new ArrayList<PVector>();
ArrayList<PVector> TEXT4 = new ArrayList<PVector>();
ArrayList<PVector> TEXT5 = new ArrayList<PVector>();
ArrayList<PVector> TEXT6 = new ArrayList<PVector>();

HashMap<String, boolean[]> FONT_DATA = new HashMap<String, boolean[]>();

PFont LETTER_FONT;

void settings(){
  if(ENTRY_MODE){
    fullScreen(P2D);
  }else{
    size(CANVAS_WIDTH, CANVAS_HEIGHT, P2D);
  }
}

boolean[] createPositionDataForLetter(String letter){
  boolean[] r = new boolean[FONT_TOTAL_CELLS];
  int r_index = 0;
  PGraphics tmp = createGraphics(FONT_PARSER_WIDTH,FONT_PARSER_HEIGHT, P2D);
  tmp.beginDraw();
  tmp.textFont(LETTER_FONT);
  tmp.background(255);
  tmp.fill(0);
  tmp.textAlign(LEFT,TOP);
  tmp.textSize(FONT_SIZE);
  tmp.text(letter, 0, 0);
  tmp.endDraw();
  tmp.loadPixels();
  for(int i = 0; i<FONT_PARSER_HEIGHT;i++){
    ArrayList<String> t = new ArrayList<String>();
    for(int j = 0; j<FONT_PARSER_WIDTH;j++){
      int index = i*FONT_PARSER_WIDTH+j;
      color c = tmp.pixels[index];
      if(red(c)>127){
        r[r_index] = false;
        t.add(" ");
      }else{
         r[r_index] = true;
         t.add("X");
      }
      r_index++;
    }
    println(t);
  }
  return r;
}

void setup(){
  //Create "DotMatrix" letter data
  LETTER_FONT = createFont("Arial",FONT_SIZE);
  
  //All possible letters, numbers, etc
  String data = "ABCDEFGHIJKLMNOPQRSTUVWXYZÅÄÖ 1234567890!?|_-";
  for(int letter = 0; letter < data.length();letter++){
    String data2 = ""+data.charAt(letter);
    println(data2);
    FONT_DATA.put(data2, createPositionDataForLetter(data2));
  }
  println("");
  
  
  
  
  
  //precalc text positions ??
  //TEXT1
  TEXT1 = textToLocations("HELLO", -600, -400, TEXT1);
  TEXT1 = textToLocations("WORLD!", -600, 0, TEXT1); 
  
  //TEXT2
  TEXT2 = textToLocations("WELCOME ", -800, -400, TEXT2);
  TEXT2 = textToLocations("ASSEMBLY!", -800, 0, TEXT2);
  
  //TEXT3
  TEXT3 = textToLocations("CUBE", -800, -400, TEXT3);
  TEXT3 = textToLocations("TEXT", -800, 0, TEXT3);
  
  //TEXT4
  TEXT4 = textToLocations("-------", -800, -600, TEXT4);
  TEXT4 = textToLocations("-------", -800, -300, TEXT4);
  TEXT4 = textToLocations("-------", -800, 000, TEXT4);
  TEXT4 = textToLocations("-------", -800, 300, TEXT4);
  TEXT4 = textToLocations("| | | |", -800, -400, TEXT4);
  TEXT4 = textToLocations("| | | |", -800, -100, TEXT4);
  TEXT4 = textToLocations("| | | |", -800, 200, TEXT4);

  //TEXT5
  TEXT5 = textToLocations("-------", -800, -600, TEXT5);
  TEXT5 = textToLocations("-------", -800, -300, TEXT5);
  TEXT5 = textToLocations("-------", -800, 000, TEXT5);
  TEXT5 = textToLocations("-------", -800, 300, TEXT5);
  TEXT5 = textToLocations("| |X|O|", -800, -400, TEXT5);
  TEXT5 = textToLocations("| |X|O|", -800, -100, TEXT5);
  TEXT5 = textToLocations("| |X| |", -800, 200, TEXT5);
  
  //TEXT6
  TEXT6 = textToLocations("EPIC", -600, -400, TEXT6);
  TEXT6 = textToLocations("VICTORY", -600, 0, TEXT6); 
  
  
  frameRate(60);
  
  moonlander = Moonlander.initWithSoundtrack(this, "musa3.wav", BPM, 8);
  
  if(ENTRY_MODE){
    noCursor();
    moonlander.start("data/assembly2018.rocket");
  }else{
    moonlander.start("localhost", 1338, "data/assembly2018.rocket");
  }
  
}

ArrayList<PVector> textToLocations(String text, int startX, int startY){
  return textToLocations(text, startX, startY, new ArrayList<PVector>());
}

ArrayList<PVector> textToLocations(String text, int startX, int startY, ArrayList<PVector> r){
  int letterStartX = startX;
  int letterStartY = startY;

  for(int i=0;i<text.length();i++){
    String letter = ""+text.charAt(i);
    //println(letter);
    int x = letterStartX;
    int y = letterStartY;
    int dataIter = 0;
    boolean[] data = FONT_DATA.get(letter);
    //iterate dot matrix data for the letter
    for(int lY = 0; lY< FONT_PARSER_HEIGHT; lY++){

      y = y + FONT_OUTPUT_DOT_SPACING;
      x = letterStartX;
      for(int lX = 0; lX<FONT_PARSER_WIDTH; lX++){
        x = x + FONT_OUTPUT_DOT_SPACING;
        
        if(data[dataIter]){
          //Draw "dot"
          r.add(new PVector(x,y));
        }
        dataIter++;
      }
    }
    letterStartX = letterStartX + FONT_OUTPUT_LETTER_SPACING;
    //letterStartY = letterStartY + FONT_OUTPUT_LETTER_SPACING;
  }
  return r;
}

void visualizeDot(PVector pos){
  rectMode(CENTER);
  fill(255);
  rect(pos.x,pos.y,FONT_OUTPUT_RECT_SIZE,FONT_OUTPUT_RECT_SIZE);
}

void visualize(ArrayList<PVector> data){
  for(PVector vec : data){
    visualizeDot(vec);
  }
}

ArrayList<PVector> calcStartingPoints(ArrayList<PVector> textStart, ArrayList<PVector> textEnd){
  ArrayList<PVector> r = new ArrayList<PVector>();
  ArrayList<PVector> options = new ArrayList<PVector>();
  for(PVector v : textEnd){
    //reinit options if empty
    if(options.isEmpty()){
     for(PVector tmp : textStart){
       options.add(tmp);
     }
    }
    
    //find longest away from the ones that are available
    PVector chosen = options.get(0);
    float chosenLen = 1000000000000F; //large number
    for(PVector opt : options){
      float len = v.dist(opt);
      if(len < chosenLen){
        chosen = opt;
        chosenLen = len;
      }
    }
    options.remove(chosen);
    r.add(chosen);
  }  
  return r;
}


void textTransform(float change, ArrayList<PVector> text1, ArrayList<PVector> text2){
    ArrayList<PVector> s2 = new ArrayList<PVector>();
    
    ArrayList<PVector> actualEnd = new ArrayList<PVector>();
    for(PVector v : text2){
      actualEnd.add(v);    
    }
    
    //force end result to have at least same amount points as start
    //no pretty but works good enough..
    int c = 0;
    while(actualEnd.size() < text1.size()){
      actualEnd.add(actualEnd.get(c));
      c++;
    }
    ArrayList<PVector> sp = calcStartingPoints(text1, actualEnd);
        
    for(int i = 0 ;i < actualEnd.size(); i++){
      PVector s1 = sp.get(i);
      PVector s = actualEnd.get(i);
      s2.add(new PVector(map(change, 0, 1, s1.x, s.x), map(change,0,1,s1.y, s.y)));
    }
    visualize(s2);  
}

void scene5(){
  //grid (lazy..)
  textTransform(1, TEXT3, TEXT4);
  
  //tic-tac-toe
  ArrayList<PVector> txt5 = new ArrayList<PVector>();
  int phase = moonlander.getIntValue("change");
  String s1 = "| | | |";
  String s2 = "| | | |";
  String s3 = "| | | |";
  if(phase > 0){
    s1 = "| |X| |";
  }
  if(phase > 1){
    s1 = "| |X|O|";
  }
  if(phase > 2){
    s2 = "| |X| |"; 
  }
  if(phase > 3){
    s2 = "| |X|O|"; 
  }
  if(phase > 4){
    s3 = "| |X| |"; 
  }  
  
  
  
  txt5 = textToLocations(s1, -800, -400, txt5);
  txt5 = textToLocations(s2, -800, -100, txt5);
  txt5 = textToLocations(s3, -800, 200, txt5);
  visualize(txt5);
}

void draw(){
  moonlander.update();
  float time = (float) moonlander.getCurrentTime();
  //TODO moonlander init here
  //TODO time handling here
  
  //resolution independent scaling
  translate(width/2, height/2);
  scale(height / 1000.0);
  
  background(0);
  
  ArrayList<PVector> data = new ArrayList<PVector>();
  
  int scene = moonlander.getIntValue("scene");

  //scene 1
  if(scene == 1){
    float s1test = (float) moonlander.getValue("change");
    ArrayList<PVector> s1 = new ArrayList<PVector>();
    for(PVector vec : TEXT1){
      s1.add(new PVector(map(s1test, 0, 1, 0, vec.x), map(s1test, 0, 1, 0, vec.y)));
    }  
    visualize(s1);
  }
  
  if(scene == 2){
    float s2test = (float) moonlander.getValue("change");
    textTransform(s2test, TEXT1, TEXT2);
  }
  
  if(scene == 3){
    float change = (float) moonlander.getValue("change");
    textTransform(change, TEXT2, TEXT3);
  }
  
  if(scene == 4){
    float change = (float) moonlander.getValue("change");
    textTransform(change, TEXT3, TEXT4);
  }
  
  if(scene == 5){
    scene5();
  }

  if(scene == 6){
    float change = (float) moonlander.getValue("change");
    textTransform(change, TEXT5, TEXT6);
  }
  
  
  //"exit scene"
  if(scene > 6){
    exit();
  }
  
  //println(moonlander.getCurrentTime());
}
